package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.RiskNumIndex;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.censoft.censoftrongtong.service.IRiskNumIndexService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 风险数量系数Controller
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
@RestController
@RequestMapping("/system/riskNumIndex")
public class RiskNumIndexController extends BaseController
{
    @Autowired
    private IRiskNumIndexService riskNumIndexService;

    /**
     * 查询风险数量系数列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskNumIndex:list')")
    @GetMapping("/list")
    public TableDataInfo list(RiskNumIndex riskNumIndex)
    {
        startPage();
        List<RiskNumIndex> list = riskNumIndexService.selectRiskNumIndexList(riskNumIndex);
        return getDataTable(list);
    }

    /**
     * 导出风险数量系数列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskNumIndex:export')")
    @Log(title = "风险数量系数", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, RiskNumIndex riskNumIndex)
    {
        List<RiskNumIndex> list = riskNumIndexService.selectRiskNumIndexList(riskNumIndex);
        ExcelUtil<RiskNumIndex> util = new ExcelUtil<RiskNumIndex>(RiskNumIndex.class);
        util.exportExcel(response, list, "风险数量系数数据");
    }

    /**
     * 获取风险数量系数详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:riskNumIndex:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(riskNumIndexService.selectRiskNumIndexById(id));
    }

    /**
     * 新增风险数量系数
     */
    @PreAuthorize("@ss.hasPermi('system:riskNumIndex:add')")
    @Log(title = "风险数量系数", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RiskNumIndex riskNumIndex)
    {
        return toAjax(riskNumIndexService.insertRiskNumIndex(riskNumIndex));
    }

    /**
     * 修改风险数量系数
     */
    @PreAuthorize("@ss.hasPermi('system:riskNumIndex:edit')")
    @Log(title = "风险数量系数", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RiskNumIndex riskNumIndex)
    {
        return toAjax(riskNumIndexService.updateRiskNumIndex(riskNumIndex));
    }

    /**
     * 删除风险数量系数
     */
    @PreAuthorize("@ss.hasPermi('system:riskNumIndex:remove')")
    @Log(title = "风险数量系数", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(riskNumIndexService.deleteRiskNumIndexByIds(ids));
    }
}
