package com.censoft.censoftrongtong.controller;

import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrol;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.censoft.censoftrongtong.service.ICurrentRiskUserPatrolService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 巡查执行管理Controller
 *
 * @author baode
 * @date 2023-12-05
 */
@RestController
@AllArgsConstructor
@RequestMapping(value = {"/risk/riskUserPatrol", "/app-api/risk/riskUserPatrol"})
public class CurrentRiskUserPatrolController extends BaseController {
    private ICurrentRiskUserPatrolService currentRiskUserPatrolService;

    @GetMapping("/getPatrolProjectList")
    public AjaxResult getPatrolProjectList() {

        List<LedgerProject> list = currentRiskUserPatrolService.getPatrolProjectList(getUserId());
        return  success(list) ;
    }


    /**
     * 查询巡查执行管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskUserPatrol currentRiskUserPatrol) {
        startPage();
        List<CurrentRiskUserPatrol> list = currentRiskUserPatrolService.selectCurrentRiskUserPatrolList(currentRiskUserPatrol);
        return getDataTable(list);
    }

    /**
     * 导出巡查执行管理列表
     */
    @PreAuthorize("@ss.hasPermi('risk:riskUserPatrol:export')")
    @Log(title = "巡查执行管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskUserPatrol currentRiskUserPatrol) {
        List<CurrentRiskUserPatrol> list = currentRiskUserPatrolService.selectCurrentRiskUserPatrolList(currentRiskUserPatrol);
        ExcelUtil<CurrentRiskUserPatrol> util = new ExcelUtil<CurrentRiskUserPatrol>(CurrentRiskUserPatrol.class);
        util.exportExcel(response, list, "巡查执行管理数据");
    }

    /**
     * 获取巡查执行管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('risk:riskUserPatrol:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return success(currentRiskUserPatrolService.selectCurrentRiskUserPatrolById(id));
    }

    /**
     * 新增巡查执行管理
     */
    @PreAuthorize("@ss.hasPermi('risk:riskUserPatrol:add')")
    @Log(title = "巡查执行管理", businessType = BusinessType.INSERT)
    @PostMapping("save")
    public AjaxResult add(@RequestBody CurrentRiskUserPatrol currentRiskUserPatrol) {
        return toAjax(currentRiskUserPatrolService.insertCurrentRiskUserPatrol(currentRiskUserPatrol));
    }

    /**
     * 修改巡查执行管理
     */
    @PreAuthorize("@ss.hasPermi('risk:riskUserPatrol:edit')")
    @Log(title = "巡查执行管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskUserPatrol currentRiskUserPatrol) {
        return toAjax(currentRiskUserPatrolService.updateCurrentRiskUserPatrol(currentRiskUserPatrol));
    }

    /**
     * 删除巡查执行管理
     */
    @PreAuthorize("@ss.hasPermi('risk:riskUserPatrol:remove')")
    @Log(title = "巡查执行管理", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(currentRiskUserPatrolService.deleteCurrentRiskUserPatrolByIds(ids));
    }
}
