package com.censoft.censoftrongtong.service.impl;

import com.censoft.censoftrongtong.domain.LawList;
import com.censoft.censoftrongtong.mapper.LawListMapper;
import com.censoft.censoftrongtong.service.ILawListService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
/**
 * 法律法规库Service业务层处理
 * 
 * @author ruoyi
 * @date 2024-03-27
 */
@Service
public class LawListServiceImpl extends MPJBaseServiceImpl<LawListMapper, LawList> implements ILawListService
{
    @Autowired
    private LawListMapper lawListMapper;

    /**
     * 查询法律法规库
     * 
     * @param id 法律法规库主键
     * @return 法律法规库
     */
    @Override
    public LawList selectLawListById(Long id)
    {
        return lawListMapper.selectLawListById(id);
    }

    /**
     * 查询法律法规库列表
     * 
     * @param lawList 法律法规库
     * @return 法律法规库
     */
    @Override
    public List<LawList> selectLawListList(LawList lawList)
    {
        return lawListMapper.selectLawListList(lawList);
    }

    /**
     * 新增法律法规库
     * 
     * @param lawList 法律法规库
     * @return 结果
     */
    @Override
    public int insertLawList(LawList lawList)
    {
        lawList.setCreateTime(DateUtils.getNowDate());
        return lawListMapper.insertLawList(lawList);
    }

    /**
     * 修改法律法规库
     * 
     * @param lawList 法律法规库
     * @return 结果
     */
    @Override
    public int updateLawList(LawList lawList)
    {
        lawList.setUpdateTime(DateUtils.getNowDate());
        return lawListMapper.updateLawList(lawList);
    }

    /**
     * 批量删除法律法规库
     * 
     * @param ids 需要删除的法律法规库主键
     * @return 结果
     */
    @Override
    public int deleteLawListByIds(Long[] ids)
    {
        return lawListMapper.deleteLawListByIds(ids);
    }

    /**
     * 删除法律法规库信息
     * 
     * @param id 法律法规库主键
     * @return 结果
     */
    @Override
    public int deleteLawListById(Long id)
    {
        return lawListMapper.deleteLawListById(id);
    }
}
