package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.LedgerBuilding;
import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppApproveDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppDetailsDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppListDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppTaskDetailsDto;
import com.censoft.censoftrongtong.domain.vo.RiskPlanExportVO;
import com.censoft.censoftrongtong.enums.RiskPlanStatusType;
import com.github.yulichang.base.MPJBaseService;

import java.util.List;

/**
 * 风险计划Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface IRiskPlanService extends MPJBaseService<RiskPlan>
{
    /**
     * 查询风险计划
     * 
     * @param id 风险计划主键
     * @return 风险计划
     */
    public RiskPlan selectRiskPlanById(Long id);

    /**
     * 查询风险计划列表
     * 
     * @param riskPlan 风险计划
     * @return 风险计划集合
     */
    public List<RiskPlanAppTaskDetailsDto> selectRiskPlanList(RiskPlan riskPlan);

    /**
     * 新增风险计划
     * 
     * @param riskPlan 风险计划
     * @return 结果
     */
    public int insertRiskPlan(RiskPlan riskPlan);

    /**
     * 修改风险计划
     * 
     * @param riskPlan 风险计划
     * @return 结果
     */
    public int updateRiskPlan(RiskPlan riskPlan);

    /**
     * 批量删除风险计划
     * 
     * @param ids 需要删除的风险计划主键集合
     * @return 结果
     */
    public int deleteRiskPlanByIds(Long[] ids);

    /**
     * 删除风险计划信息
     * 
     * @param id 风险计划主键
     * @return 结果
     */
    public int deleteRiskPlanById(Long id);

    int saveRiskPlan(RiskPlan riskPlan);

    List<RiskPlanAppListDto> getRiskPlanAppListDtoList(List<RiskPlanStatusType> statusList, Long createUserId
            , Long leaderUserId, Long workUserId,String name);

    RiskPlanAppDetailsDto getRiskPlanAppDetailsDtoByPlanId(Long planId,Long buildingId);

    List<LedgerBuilding> getBuildingListByPlanId(Long planId);

    int approveAppApproveDto(RiskPlanAppApproveDto appApproveDto);

    int revokeByPlanId(Long planId, Long userId);

    List<RiskPlanAppListDto> getRiskPlanAppListDtoListByApproveUser(Long userId,String status,String result);

    List<RiskPlanAppListDto> getRiskPlanAppListDtoListByCreateUserDeptId(Long deptId,String name);

    int updateRiskPlanById(RiskPlan riskPlan);

    RiskPlanExportVO riskPlanExport(Long id);
}
