package com.censoft.censoftrongtong.domain.dto.statistics;

import lombok.Data;

import java.util.List;

@Data
public class ProjectStatisticsDetailDto {
    private static final long serialVersionUID = 1L;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 评估时间
     */
    private String evaluationTime;

    /**
     * 评估数据
     */
    private EvaluationDataDto evaluationData;

    /**
     * 风险总数量
     */
    private Long riskSumNum;
    /**
     * 固有风险数量
     */
    private Long inherentNum;
    /**
     * 现状风险数量
     */
    private Long existingNum;
    /**
     * 风险等级（固有）
     */
    private List<RiskLevelStatisticsDto> inherentLevelStatics;
    /**
     * 风险等级（现状）
     */
    private List<RiskLevelStatisticsDto> existingLevelStatics;
}
