package com.censoft.censoftrongtong.domain.dto.statistics;


import lombok.Data;

@Data
public class MapStatisticsQueryDto {
    private static final long serialVersionUID = 1L;

    /**
     * 级别 默认传1 点击市级传2  依次类推
     */
    private Integer level;
    /**
     * 默认不传，点击后传汉字
     */
    private String areaName;
    /**
     * 0固有 1现状
     */
    private String type;

    public String getLevelName() {
        String levelName = "";
        if (this.level == null)
            return levelName;
        switch (this.level) {
            case 0:
                levelName = "province";
                break;
            case 1:
                levelName = "city";
                break;
            case 2:
                levelName = "district";
                break;
            case 3:
                levelName = "street";
                break;

        }
        return levelName;
    }

    public String getParentLevel() {
        String levelName = "";
        if (this.level == null)
            return levelName;
        switch (this.level) {
            case 1:
                if (this.getAreaName().contains("北京") || this.getAreaName().contains("重庆") || this.getAreaName().contains("上海") || this.getAreaName().contains("天津"))
                    levelName = "city";
                else
                    levelName = "province";
                break;
            case 2:
                levelName = "city";
                break;
            case 3:
                levelName = "district";
                break;
        }
        return levelName;
    }


}
