package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.RiskLevelProportion;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.censoft.censoftrongtong.service.IRiskLevelProportionService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 风险等级占比和系数Controller
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
@RestController
@RequestMapping("/system/riskLevelProportion")
public class RiskLevelProportionController extends BaseController
{
    @Autowired
    private IRiskLevelProportionService riskLevelProportionService;

    /**
     * 查询风险等级占比和系数列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskLevelProportion:list')")
    @GetMapping("/list")
    public TableDataInfo list(RiskLevelProportion riskLevelProportion)
    {
        startPage();
        List<RiskLevelProportion> list = riskLevelProportionService.selectRiskLevelProportionList(riskLevelProportion);
        return getDataTable(list);
    }

    /**
     * 导出风险等级占比和系数列表
     */
    @PreAuthorize("@ss.hasPermi('system:riskLevelProportion:export')")
    @Log(title = "风险等级占比和系数", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, RiskLevelProportion riskLevelProportion)
    {
        List<RiskLevelProportion> list = riskLevelProportionService.selectRiskLevelProportionList(riskLevelProportion);
        ExcelUtil<RiskLevelProportion> util = new ExcelUtil<RiskLevelProportion>(RiskLevelProportion.class);
        util.exportExcel(response, list, "风险等级占比和系数数据");
    }

    /**
     * 获取风险等级占比和系数详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:riskLevelProportion:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(riskLevelProportionService.selectRiskLevelProportionById(id));
    }

    /**
     * 新增风险等级占比和系数
     */
    @PreAuthorize("@ss.hasPermi('system:riskLevelProportion:add')")
    @Log(title = "风险等级占比和系数", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody RiskLevelProportion riskLevelProportion)
    {
        return toAjax(riskLevelProportionService.insertRiskLevelProportion(riskLevelProportion));
    }

    /**
     * 修改风险等级占比和系数
     */
    @PreAuthorize("@ss.hasPermi('system:riskLevelProportion:edit')")
    @Log(title = "风险等级占比和系数", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody RiskLevelProportion riskLevelProportion)
    {
        return toAjax(riskLevelProportionService.updateRiskLevelProportion(riskLevelProportion));
    }

    /**
     * 删除风险等级占比和系数
     */
    @PreAuthorize("@ss.hasPermi('system:riskLevelProportion:remove')")
    @Log(title = "风险等级占比和系数", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(riskLevelProportionService.deleteRiskLevelProportionByIds(ids));
    }
}
