package com.censoft.censoftrongtong.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.CurrentRiskDetailAbnormal;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrol;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrolVO;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.censoft.censoftrongtong.service.ICurrentRiskDetailAbnormalService;
import com.censoft.censoftrongtong.service.ICurrentRiskUserPatrolService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysUploadFileService;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 巡查执行管理Controller
 *
 * @author baode
 * @date 2023-12-05
 */
@RestController
@AllArgsConstructor
@RequestMapping(value = {"/risk/riskUserPatrol", "/app-api/risk/riskUserPatrol"})
public class CurrentRiskUserPatrolController extends BaseController {
    private ICurrentRiskUserPatrolService currentRiskUserPatrolService;
    private ICurrentRiskDetailAbnormalService currentRiskDetailAbnormalService;

    @Resource
    private ISysUploadFileService uploadFileService;

    @GetMapping("/getPatrolProjectList")
    public AjaxResult getPatrolProjectList() {

        List<LedgerProject> list = currentRiskUserPatrolService.getPatrolProjectList(getUserId());
        return  success(list) ;
    }


    /**
     * 查询巡查执行管理列表
     */
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskUserPatrol currentRiskUserPatrol) {
        startPage();
        List<CurrentRiskUserPatrol> list = currentRiskUserPatrolService.selectCurrentRiskUserPatrolList(currentRiskUserPatrol);
        return getDataTable(list);
    }

    @GetMapping("/detailList")
    public TableDataInfo detailList(CurrentRiskUserPatrol currentRiskUserPatrol) {
        startPage();
        List<CurrentRiskUserPatrolVO>  list = currentRiskUserPatrolService.selectCurrentRiskUserPatrolDetailList(currentRiskUserPatrol);
        return getDataTable(list);
    }


    /**
     * 导出巡查执行管理列表
     */
    @Log(title = "巡查执行管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskUserPatrol currentRiskUserPatrol) {
        List<CurrentRiskUserPatrol> list = currentRiskUserPatrolService.selectCurrentRiskUserPatrolList(currentRiskUserPatrol);
        ExcelUtil<CurrentRiskUserPatrol> util = new ExcelUtil<CurrentRiskUserPatrol>(CurrentRiskUserPatrol.class);
        util.exportExcel(response, list, "巡查执行管理数据");
    }

    /**
     * 获取巡查执行管理详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return success(currentRiskUserPatrolService.selectCurrentRiskUserPatrolById(id));
    }


    /**
     * 获取巡查记录详情查看
     */
    @GetMapping(value = "/patrolInfoDetail/{id}")
    public AjaxResult getPatrolInfoDetail(@PathVariable("id") Long id) {
        CurrentRiskUserPatrolVO currentRiskUserPatrolVO=currentRiskUserPatrolService.selectCurrentRiskUserPatrolDetail(id);
        if(currentRiskUserPatrolVO != null){
            if (currentRiskUserPatrolVO.getExceptStatus()!=null&&currentRiskUserPatrolVO.getExceptStatus().equals("1")) {//如果有异常信息加入详情
                QueryWrapper<CurrentRiskDetailAbnormal>  queryWrapper = new QueryWrapper<>();
                queryWrapper.lambda().eq(CurrentRiskDetailAbnormal::getPatrolId,currentRiskUserPatrolVO.getId());
                CurrentRiskDetailAbnormal currentRiskDetailAbnormal= currentRiskDetailAbnormalService.getOne(queryWrapper);
                if (!StrUtil.hasEmpty(currentRiskDetailAbnormal.getAbnormalPics())) {
                    List<Long> fileIds = Arrays.stream(currentRiskDetailAbnormal.getAbnormalPics().split(","))
                            .map(Long::parseLong)
                            .collect(Collectors.toList());
                    currentRiskDetailAbnormal.setFiles(uploadFileService.selectSysFileByFileIds(fileIds));
                }
                if (currentRiskDetailAbnormal!=null) {
                    currentRiskUserPatrolVO.setCurrentailAbnormal(currentRiskDetailAbnormal);
                }
            }
        }
        return success(currentRiskUserPatrolVO);
    }

    /**
     * 新增巡查执行管理
     */
    @Log(title = "巡查执行管理", businessType = BusinessType.INSERT)
    @PostMapping("save")
    public AjaxResult add(@RequestBody CurrentRiskUserPatrol currentRiskUserPatrol) {
        return toAjax(currentRiskUserPatrolService.insertCurrentRiskUserPatrol(currentRiskUserPatrol));
    }

    /**
     * 修改巡查执行管理
     */
    @Log(title = "巡查执行管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskUserPatrol currentRiskUserPatrol) {
        return toAjax(currentRiskUserPatrolService.updateCurrentRiskUserPatrol(currentRiskUserPatrol));
    }

    /**
     * 删除巡查执行管理
     */
    @Log(title = "巡查执行管理", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(currentRiskUserPatrolService.deleteCurrentRiskUserPatrolByIds(ids));
    }
}
