package com.censoft.censoftrongtong.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.CurrentRiskUserHoliday;
import com.censoft.censoftrongtong.service.ICommonMessageInfoService;
import com.censoft.censoftrongtong.service.ICurrentRiskUserHolidayService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.StringUtils;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.system.service.ISysUserService;
import lombok.AllArgsConstructor;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * 现状风险巡查用户请假Controller
 *
 * @author ruoyi
 * @date 2023-12-05
 */
@RestController
@AllArgsConstructor
@RequestMapping(value = {"/risk/currentRiskHoliday", "/app-api/risk/currentRiskHoliday"})
public class CurrentRiskUserHolidayController extends BaseController {
    private ICurrentRiskUserHolidayService currentRiskUserHolidayService;
    private ISysUserService sysUserService;
    private ICommonMessageInfoService commonMessageInfoService;

    /**
     * 查询现状风险巡查用户请假列表
     */
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskUserHoliday currentRiskUserHoliday) {
        startPage();
        QueryWrapper<CurrentRiskUserHoliday> queryWrapper = new QueryWrapper<>();
        if (currentRiskUserHoliday.getType() == null) {

        } else {
            if ("0".equals(currentRiskUserHoliday.getType())) {
                //申请人
                queryWrapper.eq("apply_user_id", getUserId());
            } else {
                //审批人
                queryWrapper.in("apply_user_id", currentRiskUserHolidayService.memberUserIds(getUserId()));
            }
        }

        if (!StringUtils.isEmpty(currentRiskUserHoliday.getStatus())) {
            queryWrapper.eq("status", currentRiskUserHoliday.getStatus());
        }
        queryWrapper.orderByAsc(" status");
        queryWrapper.orderByDesc("holiday_time");
        List<CurrentRiskUserHoliday> list = currentRiskUserHolidayService.list(queryWrapper);
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(holiday -> {
                if ("0".equals(currentRiskUserHoliday.getType())) {
                    SysUser sysUser = sysUserService.selectUserById(getUserId());
                    holiday.setApplyUserName(sysUser.getNickName());
                } else {
                    SysUser sysUser = sysUserService.selectUserById(holiday.getApplyUserId());
                    holiday.setApplyUserName(sysUser.getNickName());
                }
                if (holiday.getApproveUserId() != null) {
                    SysUser sysUser = sysUserService.selectUserById(holiday.getApproveUserId());
                    holiday.setApproveUserName(sysUser.getNickName());
                }
            });
        }
        return getDataTable(list);
    }

    /**
     * 导出现状风险巡查用户请假列表
     */
    @Log(title = "现状风险巡查用户请假", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskUserHoliday currentRiskUserHoliday) {
        List<CurrentRiskUserHoliday> list = currentRiskUserHolidayService.selectCurrentRiskUserHolidayList(currentRiskUserHoliday);
        ExcelUtil<CurrentRiskUserHoliday> util = new ExcelUtil<CurrentRiskUserHoliday>(CurrentRiskUserHoliday.class);
        util.exportExcel(response, list, "现状风险巡查用户请假数据");
    }

    /**
     * 获取现状风险巡查用户请假详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return success(currentRiskUserHolidayService.selectCurrentRiskUserHolidayById(id));
    }

    /**
     * 新增现状风险巡查用户请假
     */
    @Log(title = "现状风险巡查用户请假", businessType = BusinessType.INSERT)
    @PostMapping("/save")
    public AjaxResult add(@RequestBody CurrentRiskUserHoliday currentRiskUserHoliday) {
        if (null == currentRiskUserHoliday.getId()) {
            currentRiskUserHoliday.setApplyUserId(getUserId());
            currentRiskUserHoliday.setApplyTime(new Date());
            currentRiskUserHoliday.setStatus("0");
            //TODO 查询上级项目经理 改为已知晓，不做逻辑处理
            currentRiskUserHolidayService.insertCurrentRiskUserHoliday(currentRiskUserHoliday);
        } else {
            currentRiskUserHoliday.setApproveTime(new Date());
            currentRiskUserHoliday.setApproveUserId(getUserId());
            currentRiskUserHolidayService.updateCurrentRiskUserHoliday(currentRiskUserHoliday);
        }
        SysUser user = sysUserService.selectUserById(getUserId());
        //给上报人发消息
        commonMessageInfoService.insertMessageInfo(currentRiskUserHoliday.getId() + "", "finish", "请假提醒"
                , "今日用户'" + user.getNickName() + "'已请假，望知晓！"
                , "0", getUsername(), "请假提醒", "", "/patrolCancle/detail?id=" + currentRiskUserHoliday.getId(), user.getUserName());
        return AjaxResult.success();
    }

    /**
     * 修改现状风险巡查用户请假
     */
    @Log(title = "现状风险巡查用户请假", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskUserHoliday currentRiskUserHoliday) {
        return toAjax(currentRiskUserHolidayService.updateCurrentRiskUserHoliday(currentRiskUserHoliday));
    }

    /**
     * 删除现状风险巡查用户请假
     */
    @Log(title = "现状风险巡查用户请假", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(currentRiskUserHolidayService.deleteCurrentRiskUserHolidayByIds(ids));
    }
}
