package com.ruoyi.system.mapper;

import java.util.List;
import com.ruoyi.system.domain.MessageInfo;
import com.github.yulichang.base.MPJBaseMapper;

/**
 * 消息信息Mapper接口
 * 
 * @author ruoyi
 * @date 2024-01-09
 */
public interface MessageInfoMapper  extends MPJBaseMapper<MessageInfo>
{
    /**
     * 查询消息信息
     * 
     * @param id 消息信息主键
     * @return 消息信息
     */
    public MessageInfo selectMessageInfoById(String id);

    /**
     * 查询消息未读信息数量
     */
    public int selectUnReadCount(String loginName);

    /**
     * 查询消息信息列表
     * 
     * @param messageInfo 消息信息
     * @return 消息信息集合
     */
    public List<MessageInfo> selectMessageInfoList(MessageInfo messageInfo);

    /**
     * 新增消息信息
     * 
     * @param messageInfo 消息信息
     * @return 结果
     */
    public int insertMessageInfo(MessageInfo messageInfo);

    /**
     * 清除未读
     */
    public boolean updateChangeStatus(String loginName);

    /**
     * 修改消息信息
     * 
     * @param messageInfo 消息信息
     * @return 结果
     */
    public int updateMessageInfo(MessageInfo messageInfo);

    /**
     * 删除消息信息
     * 
     * @param id 消息信息主键
     * @return 结果
     */
    public int deleteMessageInfoById(String id);

    /**
     * 批量删除消息信息
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMessageInfoByIds(String[] ids);
}
