package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 基础数据-楼层对象 ledger_floor
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class LedgerFloor extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 楼宇id */
    @Excel(name = "楼宇id")
    private Long buildingId;

    /** 楼层名称 */
    @Excel(name = "楼层名称")
    private String name;

    /** 楼层属性 */
    @Excel(name = "楼层属性")
    private String type;

    /** 房间数量 */
    @Excel(name = "房间数量")
    private Long roomNumber;

    /** 状态（0正常 1停用） */
    @Excel(name = "状态", readConverterExp = "0=正常,1=停用")
    private String status;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    /**
     * 楼栋名称
     */
    @TableField(exist = false)
    private String buildingName;


}
