package com.censoft.censoftrongtong.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.CurrentRiskPostMapper;
import com.censoft.censoftrongtong.domain.CurrentRiskPost;
import com.censoft.censoftrongtong.service.ICurrentRiskPostService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 现状风险岗位Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-12-01
 */
@Service
public class CurrentRiskPostServiceImpl extends MPJBaseServiceImpl<CurrentRiskPostMapper, CurrentRiskPost> implements ICurrentRiskPostService
{
    @Autowired
    private CurrentRiskPostMapper currentRiskPostMapper;

    /**
     * 查询现状风险岗位
     * 
     * @param id 现状风险岗位主键
     * @return 现状风险岗位
     */
    @Override
    public CurrentRiskPost selectCurrentRiskPostById(Long id)
    {
        return currentRiskPostMapper.selectCurrentRiskPostById(id);
    }

    /**
     * 查询现状风险岗位列表
     * 
     * @param currentRiskPost 现状风险岗位
     * @return 现状风险岗位
     */
    @Override
    public List<CurrentRiskPost> selectCurrentRiskPostList(CurrentRiskPost currentRiskPost)
    {
        return currentRiskPostMapper.selectCurrentRiskPostList(currentRiskPost);
    }

    /**
     * 新增现状风险岗位
     * 
     * @param currentRiskPost 现状风险岗位
     * @return 结果
     */
    @Override
    public int insertCurrentRiskPost(CurrentRiskPost currentRiskPost)
    {
        currentRiskPost.setCreateTime(DateUtils.getNowDate());
        return currentRiskPostMapper.insertCurrentRiskPost(currentRiskPost);
    }

    /**
     * 修改现状风险岗位
     * 
     * @param currentRiskPost 现状风险岗位
     * @return 结果
     */
    @Override
    public int updateCurrentRiskPost(CurrentRiskPost currentRiskPost)
    {
        currentRiskPost.setUpdateTime(DateUtils.getNowDate());
        return currentRiskPostMapper.updateCurrentRiskPost(currentRiskPost);
    }

    /**
     * 批量删除现状风险岗位
     * 
     * @param ids 需要删除的现状风险岗位主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskPostByIds(Long[] ids)
    {
        return currentRiskPostMapper.deleteCurrentRiskPostByIds(ids);
    }

    /**
     * 删除现状风险岗位信息
     * 
     * @param id 现状风险岗位主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskPostById(Long id)
    {
        return currentRiskPostMapper.deleteCurrentRiskPostById(id);
    }
}
