package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.mapper.RiskPlanMapper;
import com.censoft.censoftrongtong.service.IRiskPlanService;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 风险计划Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanServiceImpl implements IRiskPlanService
{
    @Autowired
    private RiskPlanMapper riskPlanMapper;

    /**
     * 查询风险计划
     * 
     * @param id 风险计划主键
     * @return 风险计划
     */
    @Override
    public RiskPlan selectRiskPlanById(Long id)
    {
        return riskPlanMapper.selectRiskPlanById(id);
    }

    /**
     * 查询风险计划列表
     * 
     * @param riskPlan 风险计划
     * @return 风险计划
     */
    @Override
    public List<RiskPlan> selectRiskPlanList(RiskPlan riskPlan)
    {
        return riskPlanMapper.selectRiskPlanList(riskPlan);
    }

    /**
     * 新增风险计划
     * 
     * @param riskPlan 风险计划
     * @return 结果
     */
    @Override
    public int insertRiskPlan(RiskPlan riskPlan)
    {
        riskPlan.setCreateTime(DateUtils.getNowDate());
        return riskPlanMapper.insertRiskPlan(riskPlan);
    }

    /**
     * 修改风险计划
     * 
     * @param riskPlan 风险计划
     * @return 结果
     */
    @Override
    public int updateRiskPlan(RiskPlan riskPlan)
    {
        riskPlan.setUpdateTime(DateUtils.getNowDate());
        return riskPlanMapper.updateRiskPlan(riskPlan);
    }

    /**
     * 批量删除风险计划
     * 
     * @param ids 需要删除的风险计划主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanByIds(Long[] ids)
    {
        return riskPlanMapper.deleteRiskPlanByIds(ids);
    }

    /**
     * 删除风险计划信息
     * 
     * @param id 风险计划主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanById(Long id)
    {
        return riskPlanMapper.deleteRiskPlanById(id);
    }
}
