package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.mapper.RiskPlanInherentListMapper;
import com.censoft.censoftrongtong.service.IRiskPlanInherentListService;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 固有风险清单库Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanInherentListServiceImpl implements IRiskPlanInherentListService
{
    @Autowired
    private RiskPlanInherentListMapper riskPlanInherentListMapper;

    /**
     * 查询固有风险清单库
     * 
     * @param id 固有风险清单库主键
     * @return 固有风险清单库
     */
    @Override
    public RiskPlanInherentList selectRiskPlanInherentListById(Long id)
    {
        return riskPlanInherentListMapper.selectRiskPlanInherentListById(id);
    }

    /**
     * 查询固有风险清单库列表
     * 
     * @param riskPlanInherentList 固有风险清单库
     * @return 固有风险清单库
     */
    @Override
    public List<RiskPlanInherentList> selectRiskPlanInherentListList(RiskPlanInherentList riskPlanInherentList)
    {
        return riskPlanInherentListMapper.selectRiskPlanInherentListList(riskPlanInherentList);
    }

    /**
     * 新增固有风险清单库
     * 
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int insertRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList)
    {
        riskPlanInherentList.setCreateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.insertRiskPlanInherentList(riskPlanInherentList);
    }

    /**
     * 修改固有风险清单库
     * 
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int updateRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList)
    {
        riskPlanInherentList.setUpdateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.updateRiskPlanInherentList(riskPlanInherentList);
    }

    /**
     * 批量删除固有风险清单库
     * 
     * @param ids 需要删除的固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanInherentListByIds(Long[] ids)
    {
        return riskPlanInherentListMapper.deleteRiskPlanInherentListByIds(ids);
    }

    /**
     * 删除固有风险清单库信息
     * 
     * @param id 固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanInherentListById(Long id)
    {
        return riskPlanInherentListMapper.deleteRiskPlanInherentListById(id);
    }
}
