package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.LedgerRoom;

import java.util.List;

/**
 * 基础数据-楼层Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface ILedgerRoomService 
{
    /**
     * 查询基础数据-楼层
     * 
     * @param id 基础数据-楼层主键
     * @return 基础数据-楼层
     */
    public LedgerRoom selectLedgerRoomById(Long id);

    /**
     * 查询基础数据-楼层列表
     * 
     * @param ledgerRoom 基础数据-楼层
     * @return 基础数据-楼层集合
     */
    public List<LedgerRoom> selectLedgerRoomList(LedgerRoom ledgerRoom);

    /**
     * 新增基础数据-楼层
     * 
     * @param ledgerRoom 基础数据-楼层
     * @return 结果
     */
    public int insertLedgerRoom(LedgerRoom ledgerRoom);

    /**
     * 修改基础数据-楼层
     * 
     * @param ledgerRoom 基础数据-楼层
     * @return 结果
     */
    public int updateLedgerRoom(LedgerRoom ledgerRoom);

    /**
     * 批量删除基础数据-楼层
     * 
     * @param ids 需要删除的基础数据-楼层主键集合
     * @return 结果
     */
    public int deleteLedgerRoomByIds(Long[] ids);

    /**
     * 删除基础数据-楼层信息
     * 
     * @param id 基础数据-楼层主键
     * @return 结果
     */
    public int deleteLedgerRoomById(Long id);
}
