package com.censoft.censoftrongtong.service.impl;

import com.censoft.censoftrongtong.domain.EvaluationFactorItems;
import com.censoft.censoftrongtong.mapper.EvaluationFactorItemsMapper;
import com.censoft.censoftrongtong.service.IEvaluationFactorItemsService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
/**
 * 评估选项管理Service业务层处理
 * 
 * @author xjchen
 * @date 2023-08-08
 */
@Service
public class EvaluationFactorItemsServiceImpl extends MPJBaseServiceImpl<EvaluationFactorItemsMapper, EvaluationFactorItems> implements IEvaluationFactorItemsService
{
    @Autowired
    private EvaluationFactorItemsMapper evaluationFactorItemsMapper;

    /**
     * 查询评估选项管理
     * 
     * @param id 评估选项管理主键
     * @return 评估选项管理
     */
    @Override
    public EvaluationFactorItems selectEvaluationFactorItemsById(Long id)
    {
        return evaluationFactorItemsMapper.selectEvaluationFactorItemsById(id);
    }

    /**
     * 查询评估选项管理列表
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 评估选项管理
     */
    @Override
    public List<EvaluationFactorItems> selectEvaluationFactorItemsList(EvaluationFactorItems evaluationFactorItems)
    {
        return evaluationFactorItemsMapper.selectEvaluationFactorItemsList(evaluationFactorItems);
    }

    /**
     * 新增评估选项管理
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 结果
     */
    @Override
    public int insertEvaluationFactorItems(EvaluationFactorItems evaluationFactorItems)
    {
        evaluationFactorItems.setCreateTime(DateUtils.getNowDate());
        return evaluationFactorItemsMapper.insertEvaluationFactorItems(evaluationFactorItems);
    }

    /**
     * 修改评估选项管理
     * 
     * @param evaluationFactorItems 评估选项管理
     * @return 结果
     */
    @Override
    public int updateEvaluationFactorItems(EvaluationFactorItems evaluationFactorItems)
    {
        evaluationFactorItems.setUpdateTime(DateUtils.getNowDate());
        return evaluationFactorItemsMapper.updateEvaluationFactorItems(evaluationFactorItems);
    }

    /**
     * 批量删除评估选项管理
     * 
     * @param ids 需要删除的评估选项管理主键
     * @return 结果
     */
    @Override
    public int deleteEvaluationFactorItemsByIds(Long[] ids)
    {
        return evaluationFactorItemsMapper.deleteEvaluationFactorItemsByIds(ids);
    }

    /**
     * 删除评估选项管理信息
     * 
     * @param id 评估选项管理主键
     * @return 结果
     */
    @Override
    public int deleteEvaluationFactorItemsById(Long id)
    {
        return evaluationFactorItemsMapper.deleteEvaluationFactorItemsById(id);
    }
}
