package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.mapper.LedgerProjectMapper;
import com.censoft.censoftrongtong.mapper.RiskPlanInherentListMapper;
import com.censoft.censoftrongtong.service.ILedgerProjectService;
import com.ruoyi.common.annotation.DataScope;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 基础数据-项目Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class LedgerProjectServiceImpl extends ServiceImpl<LedgerProjectMapper, LedgerProject> implements ILedgerProjectService
{
    @Autowired
    private LedgerProjectMapper ledgerProjectMapper;

    @Resource
    private ISysUserService userService;

    /**
     * 查询基础数据-项目
     * 
     * @param id 基础数据-项目主键
     * @return 基础数据-项目
     */
    @Override
    public LedgerProject selectLedgerProjectById(Long id)
    {
        return ledgerProjectMapper.selectLedgerProjectById(id);
    }

    /**
     * 查询基础数据-项目列表
     * 
     * @param ledgerProject 基础数据-项目
     * @return 基础数据-项目
     */
    @Override
    public List<LedgerProject> selectLedgerProjectList(LedgerProject ledgerProject)
    {
        return ledgerProjectMapper.selectLedgerProjectList(ledgerProject);
    }

    /**
     * 新增基础数据-项目
     * 
     * @param ledgerProject 基础数据-项目
     * @return 结果
     */
    @Override
    public int insertLedgerProject(LedgerProject ledgerProject)
    {
        ledgerProject.setCreateTime(DateUtils.getNowDate());
        return ledgerProjectMapper.insertLedgerProject(ledgerProject);
    }

    /**
     * 修改基础数据-项目
     * 
     * @param ledgerProject 基础数据-项目
     * @return 结果
     */
    @Override
    public int updateLedgerProject(LedgerProject ledgerProject)
    {
        ledgerProject.setUpdateTime(DateUtils.getNowDate());
        return ledgerProjectMapper.updateLedgerProject(ledgerProject);
    }

    /**
     * 批量删除基础数据-项目
     * 
     * @param ids 需要删除的基础数据-项目主键
     * @return 结果
     */
    @Override
    public int deleteLedgerProjectByIds(Long[] ids)
    {
        return ledgerProjectMapper.deleteLedgerProjectByIds(ids);
    }

    /**
     * 删除基础数据-项目信息
     * 
     * @param id 基础数据-项目主键
     * @return 结果
     */
    @Override
    public int deleteLedgerProjectById(Long id)
    {
        return ledgerProjectMapper.deleteLedgerProjectById(id);
    }

    @Override
    public List<LedgerProject> getProjectListByDeptId(LedgerProject ledgerProject) {
        return ledgerProjectMapper.getProjectListByDeptId(ledgerProject);
    }

    @Override
    public List<SysUser> getUserListByDeptId(Long deptId) {
        return userService.getListByDeptIdUnder(deptId);
    }
}
