package com.censoft.censoftrongtong.service.impl;

import com.censoft.censoftrongtong.domain.RiskExistingList;
import com.censoft.censoftrongtong.mapper.RiskExistingListMapper;
import com.censoft.censoftrongtong.service.IRiskExistingListService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 现有风险清单库Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskExistingListServiceImpl extends MPJBaseServiceImpl<RiskExistingListMapper, RiskExistingList> implements IRiskExistingListService
{
    @Autowired
    private RiskExistingListMapper riskExistingListMapper;

    /**
     * 查询现有风险清单库
     * 
     * @param id 现有风险清单库主键
     * @return 现有风险清单库
     */
    @Override
    public RiskExistingList selectRiskExistingListById(Long id)
    {
        return riskExistingListMapper.selectRiskExistingListById(id);
    }

    /**
     * 查询现有风险清单库列表
     * 
     * @param riskExistingList 现有风险清单库
     * @return 现有风险清单库
     */
    @Override
    public List<RiskExistingList> selectRiskExistingListList(RiskExistingList riskExistingList)
    {
        return riskExistingListMapper.selectRiskExistingListList(riskExistingList);
    }

    /**
     * 新增现有风险清单库
     * 
     * @param riskExistingList 现有风险清单库
     * @return 结果
     */
    @Override
    public int insertRiskExistingList(RiskExistingList riskExistingList)
    {
        riskExistingList.setCreateTime(DateUtils.getNowDate());
        return riskExistingListMapper.insertRiskExistingList(riskExistingList);
    }

    /**
     * 修改现有风险清单库
     * 
     * @param riskExistingList 现有风险清单库
     * @return 结果
     */
    @Override
    public int updateRiskExistingList(RiskExistingList riskExistingList)
    {
        riskExistingList.setUpdateTime(DateUtils.getNowDate());
        return riskExistingListMapper.updateRiskExistingList(riskExistingList);
    }

    /**
     * 批量删除现有风险清单库
     * 
     * @param ids 需要删除的现有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskExistingListByIds(Long[] ids)
    {
        return riskExistingListMapper.deleteRiskExistingListByIds(ids);
    }

    /**
     * 删除现有风险清单库信息
     * 
     * @param id 现有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskExistingListById(Long id)
    {
        return riskExistingListMapper.deleteRiskExistingListById(id);
    }
}
