package com.censoft.censoftrongtong.service;

import java.util.List;
import com.censoft.censoftrongtong.domain.CurrentRiskPost;
import com.github.yulichang.base.MPJBaseService;
/**
 * 现状风险岗位Service接口
 * 
 * @author ruoyi
 * @date 2023-12-01
 */
public interface ICurrentRiskPostService  extends MPJBaseService<CurrentRiskPost>
{
    /**
     * 查询现状风险岗位
     * 
     * @param id 现状风险岗位主键
     * @return 现状风险岗位
     */
    public CurrentRiskPost selectCurrentRiskPostById(Long id);

    /**
     * 查询现状风险岗位列表
     * 
     * @param currentRiskPost 现状风险岗位
     * @return 现状风险岗位集合
     */
    public List<CurrentRiskPost> selectCurrentRiskPostList(CurrentRiskPost currentRiskPost);

    /**
     * 新增现状风险岗位
     * 
     * @param currentRiskPost 现状风险岗位
     * @return 结果
     */
    public int insertCurrentRiskPost(CurrentRiskPost currentRiskPost);

    /**
     * 修改现状风险岗位
     * 
     * @param currentRiskPost 现状风险岗位
     * @return 结果
     */
    public int updateCurrentRiskPost(CurrentRiskPost currentRiskPost);

    /**
     * 批量删除现状风险岗位
     * 
     * @param ids 需要删除的现状风险岗位主键集合
     * @return 结果
     */
    public int deleteCurrentRiskPostByIds(Long[] ids);

    /**
     * 删除现状风险岗位信息
     * 
     * @param id 现状风险岗位主键
     * @return 结果
     */
    public int deleteCurrentRiskPostById(Long id);
}
