package com.ruoyi.system.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 风险数量系数对象 risk_num_index
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
public class RiskNumIndex extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 数量系数 */
    @Excel(name = "数量系数")
    private BigDecimal riskVal;

    /** 风险等级占比（小） */
    @Excel(name = "风险等级占比", readConverterExp = "小=")
    private Long riskNumIndexMin;

    /** 风险等级占比（大） */
    @Excel(name = "风险等级占比", readConverterExp = "大=")
    private Long riskNumIndexMax;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setRiskVal(BigDecimal riskVal) 
    {
        this.riskVal = riskVal;
    }

    public BigDecimal getRiskVal() 
    {
        return riskVal;
    }
    public void setRiskNumIndexMin(Long riskNumIndexMin) 
    {
        this.riskNumIndexMin = riskNumIndexMin;
    }

    public Long getRiskNumIndexMin() 
    {
        return riskNumIndexMin;
    }
    public void setRiskNumIndexMax(Long riskNumIndexMax) 
    {
        this.riskNumIndexMax = riskNumIndexMax;
    }

    public Long getRiskNumIndexMax() 
    {
        return riskNumIndexMax;
    }
    public void setDelFlag(String delFlag) 
    {
        this.delFlag = delFlag;
    }

    public String getDelFlag() 
    {
        return delFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("riskVal", getRiskVal())
            .append("riskNumIndexMin", getRiskNumIndexMin())
            .append("riskNumIndexMax", getRiskNumIndexMax())
            .append("delFlag", getDelFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
