package com.censoft.censoftrongtong.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.CurrentRiskDetailAbnormalMapper;
import com.censoft.censoftrongtong.domain.CurrentRiskDetailAbnormal;
import com.censoft.censoftrongtong.service.ICurrentRiskDetailAbnormalService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 现状风险巡查异常信息Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@Service
public class CurrentRiskDetailAbnormalServiceImpl extends MPJBaseServiceImpl<CurrentRiskDetailAbnormalMapper, CurrentRiskDetailAbnormal> implements ICurrentRiskDetailAbnormalService
{
    @Autowired
    private CurrentRiskDetailAbnormalMapper currentRiskDetailAbnormalMapper;

    /**
     * 查询现状风险巡查异常信息
     * 
     * @param id 现状风险巡查异常信息主键
     * @return 现状风险巡查异常信息
     */
    @Override
    public CurrentRiskDetailAbnormal selectCurrentRiskDetailAbnormalById(Long id)
    {
        return currentRiskDetailAbnormalMapper.selectCurrentRiskDetailAbnormalById(id);
    }

    /**
     * 查询现状风险巡查异常信息列表
     * 
     * @param currentRiskDetailAbnormal 现状风险巡查异常信息
     * @return 现状风险巡查异常信息
     */
    @Override
    public List<CurrentRiskDetailAbnormal> selectCurrentRiskDetailAbnormalList(CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        return currentRiskDetailAbnormalMapper.selectCurrentRiskDetailAbnormalList(currentRiskDetailAbnormal);
    }

    /**
     * 新增现状风险巡查异常信息
     * 
     * @param currentRiskDetailAbnormal 现状风险巡查异常信息
     * @return 结果
     */
    @Override
    public int insertCurrentRiskDetailAbnormal(CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        currentRiskDetailAbnormal.setCreateTime(DateUtils.getNowDate());
        return currentRiskDetailAbnormalMapper.insertCurrentRiskDetailAbnormal(currentRiskDetailAbnormal);
    }

    /**
     * 修改现状风险巡查异常信息
     * 
     * @param currentRiskDetailAbnormal 现状风险巡查异常信息
     * @return 结果
     */
    @Override
    public int updateCurrentRiskDetailAbnormal(CurrentRiskDetailAbnormal currentRiskDetailAbnormal)
    {
        currentRiskDetailAbnormal.setUpdateTime(DateUtils.getNowDate());
        return currentRiskDetailAbnormalMapper.updateCurrentRiskDetailAbnormal(currentRiskDetailAbnormal);
    }

    /**
     * 批量删除现状风险巡查异常信息
     * 
     * @param ids 需要删除的现状风险巡查异常信息主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskDetailAbnormalByIds(Long[] ids)
    {
        return currentRiskDetailAbnormalMapper.deleteCurrentRiskDetailAbnormalByIds(ids);
    }

    /**
     * 删除现状风险巡查异常信息信息
     * 
     * @param id 现状风险巡查异常信息主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskDetailAbnormalById(Long id)
    {
        return currentRiskDetailAbnormalMapper.deleteCurrentRiskDetailAbnormalById(id);
    }
}
