package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.RiskAssessmentMatrixLevel;
import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.domain.dto.RiskExistingListSaveDto;
import com.censoft.censoftrongtong.domain.dto.RiskInherentListExportDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.statistics.*;
import com.github.yulichang.base.MPJBaseService;

import java.math.BigDecimal;
import java.util.*;

/**
 * 现有风险清单库Service接口
 *
 * @author ruoyi
 * @date 2023-06-26
 */
public interface IRiskPlanExistingListService extends MPJBaseService<RiskPlanExistingList> {

    /**
     * 风险数量，年度风险数量
     *
     * @param areaName
     * @param beginTime
     * @return
     */
    public Long getNationalRiskNum(String areaName, Date beginTime,Long peojectId);

    /**
     * 总体风险指数排名
     *
     * @param areaName
     * @return
     */
    public List<RiskIndexRankingDto> getRiskIndexRanking(String areaName);

    public LinkedHashMap<String, Long> getAnnualRiskStatistics(String areaName);

    public List<RiskLevelStatisticsDto> getRiskLevelStatistics(String areaName,Long projectId);

    public List<AccidentTypeStatisticsDto> getAccidentTypeStatistics(String areaName);
    public List<RiskProjectRankingDto> getRiskProjectRanking(String areaName,String level);

    public List<RiskMapStatisticsDto> getRiskMapStatistics(MapStatisticsQueryDto queryDto);

    public List<ProjectRiskInfoDto> getProjectRiskInfo(Long projectId, Long buildingId, Long floorId,String level);

    /**
     * 查询现有风险清单库
     *
     * @param id 现有风险清单库主键
     * @return 现有风险清单库
     */
    public RiskPlanExistingList selectRiskPlanExistingListById(Long id);

    /**
     * 查询现有风险清单库列表
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 现有风险清单库集合
     */
    public List<RiskPlanExistingList> selectRiskPlanExistingListList(RiskPlanExistingList riskPlanExistingList);





    /**
     * 新增现有风险清单库
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    public int insertRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList);

    /**
     * 修改现有风险清单库
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    public int updateRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList);

    /**
     * 批量删除现有风险清单库
     *
     * @param ids 需要删除的现有风险清单库主键集合
     * @return 结果
     */
    public int deleteRiskPlanExistingListByIds(Long[] ids);

    /**
     * 删除现有风险清单库信息
     *
     * @param id 现有风险清单库主键
     * @return 结果
     */
    public int deleteRiskPlanExistingListById(Long id);

    Boolean saveRiskExistingListSaveDto(RiskExistingListSaveDto saveDto);

    RiskPlanAppExistingListDetailsDto getRiskPlanAppExistingListDetailsDtoByExistingId(Long existingId);

    /**
     * 计算现状风险等级
     * @param buildingId
     * @param score
     * @return
     */
    Map<String, String>  getRiskLevelByScore(Long buildingId, BigDecimal score);


    /**
     * 获取现状风险台账
     * @param riskInherentListExportDto
     * @return
     */
    List<RiskInherentListExportDto> getPlanExistingList(RiskInherentListExportDto riskInherentListExportDto);

}
