package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.domain.dto.RiskInherentListExportDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.statistics.*;
import com.github.yulichang.base.MPJBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.*;

/**
 * 现有风险清单库Mapper接口
 *
 * @author ruoyi
 * @date 2023-06-26
 */
public interface RiskPlanExistingListMapper extends MPJBaseMapper<RiskPlanExistingList> {

    /**
     * 风险数量，年度风险数量
     *
     * @param areaName
     * @param beginTime
     * @return
     */
    public Long getNationalRiskNum(@Param("areaName") String areaName, @Param("beginTime") Date beginTime,@Param("projectId")Long projectId);

    /**
     * 总体风险指数排名
     *
     * @param areaName
     * @return
     */
    public List<RiskIndexRankingDto> getRiskIndexRanking(String areaName);

    /**
     * 年度风险数量统计
     *
     * @param areaName
     * @return
     */
    public LinkedHashMap<String, Long> getAnnualRiskStatistics(String areaName);

    public List<RiskLevelStatisticsDto> getRiskLevelStatistics(@Param("areaName") String areaName,@Param("projectId")Long projectId);

    public List<AccidentTypeStatisticsDto> getAccidentTypeStatistics(String areaName);

    public List<RiskProjectRankingDto> getRiskProjectRanking(@Param("areaName") String areaName, @Param("level") String level);

    public List<RiskMapStatisticsDto> getRiskMapStatistics(MapStatisticsQueryDto queryDto);

    public List<ProjectRiskInfoDto> getProjectRiskInfo(@Param("projectId") Long projectId, @Param("buildingId") Long buildingId, @Param("floorId") Long floorId,@Param("level")String level);

    /**
     * 查询现有风险清单库
     *
     * @param id 现有风险清单库主键
     * @return 现有风险清单库
     */
    public RiskPlanExistingList selectRiskPlanExistingListById(Long id);

    /**
     * 查询现有风险清单库列表
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 现有风险清单库集合
     */
    public List<RiskPlanExistingList> selectRiskPlanExistingListList(RiskPlanExistingList riskPlanExistingList);


    /**
     * 新增现有风险清单库
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    public int insertRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList);

    /**
     * 修改现有风险清单库
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    public int updateRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList);

    /**
     * 删除现有风险清单库
     *
     * @param id 现有风险清单库主键
     * @return 结果
     */
    public int deleteRiskPlanExistingListById(Long id);

    /**
     * 批量删除现有风险清单库
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteRiskPlanExistingListByIds(Long[] ids);


    List<RiskInherentListExportDto> getPlanExistingList(RiskInherentListExportDto riskInherentListExportDto);

    RiskPlanAppExistingListDetailsDto getRiskPlanAppExistingListDetailsDtoByExistingId(@Param("existingId") Long existingId);

}
