package com.censoft.censoftrongtong.domain.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 固有风险清单库对象 risk_inherent_list
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class RiskExistingListSaveDto {

    /**
     * id
     */
    private Long id;

    /**
     * 评估人id
     */
    private Long userId;

    /**
     * 固有风险id
     */
    private Long inherentId;

    /**
     * 计划id
     */
    private Long planId;

    /**
     * 房间id
     */
    private Long roomId;

    /**
     * 风险源名称
     */
    private String name;

    /**
     * 风险因素
     */
    private String factor;

    /**
     * 准事故类型
     */
    private String type;

    /**
     * 风险等级
     */
    private String level;

    /**
     * 风险等级
     */
    private BigDecimal levelScore;

    /**
     * 存在部位
     */
    private String presenceLocation;

    /**
     * 风险源照片id
     */
    private String pictureFileIds;


    /**
     * 技术措施
     */
    private String measuresProject;

    /**
     * 技术措施附件
     */
    private String measuresProjectFileIds;

    /**
     * 已采取的管控措施
     */
    private String measuresAdministration;

    /**
     * 管控责任单位
     */
    private String measuresDeptName;

    /**
     * 管控责任人
     */
    private String measuresUserName;

    /**
     * 管控责任人联系方式
     */
    private String measuresUserPhone;

    /**
     * 管理措施附件
     */
    private String measuresAdministrationFileIds;

    /**
     * 应急处置措施
     */
    private String measuresEmergency;

    /**
     * 应急处置措施附件
     */
    private String measuresEmergencyFileIds;

    /**
     * 参考依据
     */
    private String referenceBasis;

    /**
     * 评估选项ids
     */
    private String evaluationItemIds;

    /**
     * 影响因素
     */
    private String factorItems;
}
