package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntityClean;
import lombok.Data;

/**
 * 基础数据-项目对象 ledger_project
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Data
public class LedgerProject extends BaseEntityClean
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 项目名称 */
    @Excel(name = "项目名称",sort = 1)
    private String name;

    /** 项目类型 */
    @Excel(name = "项目类型",sort = 2)
    private String type;

    /** 项目业态 */
    @Excel(name = "项目业态",sort = 3)
    private String business;

    /** 组织机构id */
    private Long deptId;

    /** 省 */
    @Excel(name = "省",sort = 5)
    private String province;
    /** 市 */
    @Excel(name = "市",sort = 5)
    private String city;
    /** 区 */
    @Excel(name = "区",sort = 5)
    private String district;
    /** 街道 */
    @Excel(name = "街道",sort = 5)
    private String street;

    /** 详细地址 */
    @Excel(name = "详细地址",sort = 6)
    private String address;

    /**
     * 维度
     */
    private String lat;

    /**
     * 经度
     */
    private String lng;

    /** 0-关联 1-自建 */
    private String source;

    /** 中台楼宇id */
    private String infoAssetsId;

    /** 状态（0正常 1停用） */
    @Excel(name = "状态", dictType = "sys_normal_disable",sort = 7)
    private String status;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;

    /** 经营状态 */
    private String businessStatus;

    /** 是否为物业 */
    private Boolean propertyManagement;
    /**
     * 部门名称名称
     */
    @TableField(exist = false)
    @Excel(name = "所属区域",sort = 4)
    private String deptName;

    /**
     * 数量
     */
    @TableField(exist = false)
    private String num;




}
