package com.ruoyi.system.service;

import java.util.List;
import com.ruoyi.system.domain.RiskLevelProportion;
import com.github.yulichang.base.MPJBaseService;
/**
 * 风险等级占比和系数Service接口
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
public interface IRiskLevelProportionService  extends MPJBaseService<RiskLevelProportion>
{
    /**
     * 查询风险等级占比和系数
     * 
     * @param id 风险等级占比和系数主键
     * @return 风险等级占比和系数
     */
    public RiskLevelProportion selectRiskLevelProportionById(Long id);

    /**
     * 查询风险等级占比和系数列表
     * 
     * @param riskLevelProportion 风险等级占比和系数
     * @return 风险等级占比和系数集合
     */
    public List<RiskLevelProportion> selectRiskLevelProportionList(RiskLevelProportion riskLevelProportion);

    /**
     * 新增风险等级占比和系数
     * 
     * @param riskLevelProportion 风险等级占比和系数
     * @return 结果
     */
    public int insertRiskLevelProportion(RiskLevelProportion riskLevelProportion);

    /**
     * 修改风险等级占比和系数
     * 
     * @param riskLevelProportion 风险等级占比和系数
     * @return 结果
     */
    public int updateRiskLevelProportion(RiskLevelProportion riskLevelProportion);

    /**
     * 批量删除风险等级占比和系数
     * 
     * @param ids 需要删除的风险等级占比和系数主键集合
     * @return 结果
     */
    public int deleteRiskLevelProportionByIds(Long[] ids);

    /**
     * 删除风险等级占比和系数信息
     * 
     * @param id 风险等级占比和系数主键
     * @return 结果
     */
    public int deleteRiskLevelProportionById(Long id);
}
