package com.ruoyi.system.domain;

import java.math.BigDecimal;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.common.annotation.Excel;
import com.ruoyi.common.core.domain.BaseEntity;

/**
 * 风险等级占比和系数对象 risk_level_proportion
 *
 * @author ruoyi
 * @date 2023-11-30
 */
@Data
public class RiskLevelProportion extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 风险名称
 */
    @Excel(name = "风险名称")
    private String riskName;

    /** 风险等级占比（小） */
    @Excel(name = "风险等级占比", readConverterExp = "小=")
    private BigDecimal levelScaleMin;

    /** 风险等级占比（大） */
    @Excel(name = "风险等级占比", readConverterExp = "大=")
    private BigDecimal levelScaleMax;

    /** 风险等级系数 */
    @Excel(name = "风险等级系数")
    private BigDecimal riskGradeIndex;

    /** 删除标志（0代表存在 1代表删除） */
    private String delFlag;
    /**
     * 风险颜色
     */
    private String riskColor;


}
