package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.censoft.censoftrongtong.domain.LedgerFloor;
import com.censoft.censoftrongtong.domain.LedgerRoom;
import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.dto.LedgerFloorDto;
import com.censoft.censoftrongtong.mapper.LedgerFloorMapper;
import com.censoft.censoftrongtong.service.ILedgerFloorService;
import com.censoft.censoftrongtong.service.ILedgerRoomService;
import com.censoft.censoftrongtong.service.IRiskPlanExistingListService;
import com.censoft.censoftrongtong.service.IRiskPlanInherentListService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 基础数据-楼层Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class LedgerFloorServiceImpl extends MPJBaseServiceImpl<LedgerFloorMapper, LedgerFloor> implements ILedgerFloorService
{
    @Autowired
    private LedgerFloorMapper ledgerFloorMapper;

    @Resource
    private ILedgerRoomService ledgerRoomService;

    @Resource
    private IRiskPlanInherentListService riskPlanInherentListService;

    @Resource
    private IRiskPlanExistingListService riskPlanExistingListService;

    /**
     * 查询基础数据-楼层
     * 
     * @param id 基础数据-楼层主键
     * @return 基础数据-楼层
     */
    @Override
    public LedgerFloor selectLedgerFloorById(Long id)
    {
        return ledgerFloorMapper.selectLedgerFloorById(id);
    }

    /**
     * 查询基础数据-楼层列表
     * 
     * @param ledgerFloor 基础数据-楼层
     * @return 基础数据-楼层
     */
    @Override
    public List<LedgerFloor> selectLedgerFloorList(LedgerFloor ledgerFloor)
    {
        return ledgerFloorMapper.selectLedgerFloorList(ledgerFloor);
    }

    /**
     * 新增基础数据-楼层
     * 
     * @param ledgerFloor 基础数据-楼层
     * @return 结果
     */
    @Override
    public int insertLedgerFloor(LedgerFloor ledgerFloor)
    {
        ledgerFloor.setCreateTime(DateUtils.getNowDate());
        return ledgerFloorMapper.insertLedgerFloor(ledgerFloor);
    }

    /**
     * 修改基础数据-楼层
     * 
     * @param ledgerFloor 基础数据-楼层
     * @return 结果
     */
    @Override
    public int updateLedgerFloor(LedgerFloor ledgerFloor)
    {
        ledgerFloor.setUpdateTime(DateUtils.getNowDate());
        return ledgerFloorMapper.updateLedgerFloor(ledgerFloor);
    }

    /**
     * 批量删除基础数据-楼层
     * 
     * @param ids 需要删除的基础数据-楼层主键
     * @return 结果
     */
    @Override
    public int deleteLedgerFloorByIds(Long[] ids)
    {
        return ledgerFloorMapper.deleteLedgerFloorByIds(ids);
    }

    /**
     * 删除基础数据-楼层信息
     * 
     * @param id 基础数据-楼层主键
     * @return 结果
     */
    @Override
    public int deleteLedgerFloorById(Long id)
    {
        return ledgerFloorMapper.deleteLedgerFloorById(id);
    }

    @Override
    public List<LedgerFloorDto> getFloorListByBuildingId(Long buildingId) {
        LedgerFloor query = new LedgerFloor();
        query.setBuildingId(buildingId);
        query.setStatus("0");
        query.setDelFlag("0");
        List<LedgerFloor> ledgerFloors = selectLedgerFloorList(query);
        return getLedgerFloorDtoListByLedgerFloor(ledgerFloors);
    }

    @Override
    public Integer copyFloor(Long sourceFloorId, Long targetFloorId, Long planId, LoginUser loginUser) {
        //删除目标楼层下的数据
        List<Long> targetRoomIds = ledgerRoomService.getRoomListByFloorId(targetFloorId)
                .stream().map(LedgerRoom::getId)
                .collect(Collectors.toList());
        ledgerRoomService.deleteRoomByRoomIds(targetRoomIds);

        //复制数据
        List<LedgerRoom> sourceRoomList = ledgerRoomService.getRoomListByFloorId(sourceFloorId);
        for (LedgerRoom ledgerRoom : sourceRoomList) {
            //复制房间
            Long roomId = ledgerRoom.getId();
            ledgerRoom.setId(null);
            ledgerRoom.setFloorId(targetFloorId);
            ledgerRoom.setCreateBy(loginUser.getUsername());
            ledgerRoomService.save(ledgerRoom);

            LambdaQueryWrapper<RiskPlanInherentList> wrapper = new LambdaQueryWrapper<>();
            wrapper = wrapper.eq(RiskPlanInherentList::getRoomId,roomId);
            List<RiskPlanInherentList> riskPlanInherentLists = riskPlanInherentListService.list(wrapper);
            for (RiskPlanInherentList riskPlanInherentList : riskPlanInherentLists) {
                //复制固有
                Long inherentListId = riskPlanInherentList.getId();
                riskPlanInherentList.setId(null);
                riskPlanInherentList.setRoomId(ledgerRoom.getId());
                riskPlanInherentList.setUserId(loginUser.getUserId());
                riskPlanInherentList.setPlanId(planId);
                riskPlanInherentList.setCreateBy(loginUser.getUsername());
                riskPlanInherentListService.save(riskPlanInherentList);

                LambdaQueryWrapper<RiskPlanExistingList> wrapper2 = new LambdaQueryWrapper<>();
                wrapper2 = wrapper2.eq(RiskPlanExistingList::getInherentId,inherentListId);
                List<RiskPlanExistingList> riskPlanExistingLists = riskPlanExistingListService.list(wrapper2);
                for (RiskPlanExistingList riskPlanExistingList : riskPlanExistingLists) {
                    //复制现有
                    riskPlanExistingList.setId(null);
                    riskPlanExistingList.setInherentId(riskPlanInherentList.getId());
                    riskPlanExistingList.setUserId(loginUser.getUserId());
                    riskPlanExistingList.setPlanId(planId);
                    riskPlanExistingList.setCreateBy(loginUser.getUsername());
                    riskPlanExistingListService.save(riskPlanExistingList);
                }
            }

        }
        return 1;
    }

    private List<LedgerFloorDto> getLedgerFloorDtoListByLedgerFloor(List<LedgerFloor> ledgerFloors) {
        return ledgerFloors.stream()
                .map(LedgerFloor::getType)
                .distinct()
                .map(type->{
                    List<LedgerFloor> children = ledgerFloors
                            .stream()
                            .filter(ledgerFloor -> type.equals(ledgerFloor.getType()))
                            .collect(Collectors.toList());
                    LedgerFloorDto ledgerFloorDto = new LedgerFloorDto();
                    ledgerFloorDto.setName(type);
                    ledgerFloorDto.setChildren(children);
                    return ledgerFloorDto;
                }).collect(Collectors.toList());
    }
}
