package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.dto.*;
import com.censoft.censoftrongtong.domain.dto.statistics.*;
import com.github.yulichang.base.MPJBaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * 固有风险清单库Mapper接口
 *
 * @author ruoyi
 * @date 2023-06-26
 */
public interface RiskPlanInherentListMapper extends MPJBaseMapper<RiskPlanInherentList> {
    /**
     * 风险数量，年度风险数量
     *
     * @param areaName
     * @param beginTime
     * @return
     */
    public Long getNationalRiskNum(@Param("areaName") String areaName, @Param("beginTime") Date beginTime, @Param("projectId") Long projectId);


    /**
     * 总体风险指数排名
     *
     * @param areaName
     * @return
     */
    public List<RiskIndexRankingDto> getRiskIndexRanking(String areaName);

    /**
     * 年度风险数量统计
     *
     * @param areaName
     * @return
     */
    public LinkedHashMap<String, Long> getAnnualRiskStatistics(String areaName);

    public List<RiskLevelStatisticsDto> getRiskLevelStatistics(@Param("areaName") String areaName, @Param("projectId") Long projectId);

    public List<AccidentTypeStatisticsDto> getAccidentTypeStatistics(String areaName);

    public List<RiskProjectRankingDto> getRiskProjectRanking(@Param("areaName") String areaName, @Param("level") String level);

    public List<ProjectRiskInfoDto> getProjectRiskInfo(@Param("projectId") Long projectId, @Param("buildingId") Long buildingId, @Param("floorId") Long floorId,@Param("level")String level);

    public List<RiskMapStatisticsDto> getRiskMapStatistics(MapStatisticsQueryDto queryDto);
    /**
     * 查询固有风险清单库
     *
     * @param id 固有风险清单库主键
     * @return 固有风险清单库
     */
    public RiskPlanInherentList selectRiskPlanInherentListById(Long id);

    /**
     * 查询固有风险清单库列表
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 固有风险清单库集合
     */
    public List<RiskPlanInherentList> selectRiskPlanInherentListList(RiskPlanInherentList riskPlanInherentList);

    /**
     * 新增固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    public int insertRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList);

    /**
     * 修改固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    public int updateRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList);

    /**
     * 删除固有风险清单库
     *
     * @param id 固有风险清单库主键
     * @return 结果
     */
    public int deleteRiskPlanInherentListById(Long id);

    /**
     * 批量删除固有风险清单库
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteRiskPlanInherentListByIds(Long[] ids);


    List<RiskPlanAppInherentListDto> getInherentListByPlanId(@Param("projectId") Long projectId, @Param("buildingId") Long buildingId, @Param("floorId") Long floorId, @Param("roomId") Long roomId);

    RiskPlanAppInherentListDetailsDto getRiskPlanAppInherentListDetailsDtoByInherentId(@Param("inherentId") Long inherentId);

    List<RiskPlanAppExistingListDto> getExistingListByInherentId(@Param("inherentId") Long inherentId);

    RiskNotificationExportWordDto getRiskNotificationExportWordDto(@Param("inherentId") Long inherentId);

    List<RiskInherentListExportDto> getPlanInherentList(RiskInherentListExportDto riskInherentListExportDto);
}
