package com.censoft.censoftrongtong.mapper;

import java.util.List;

import com.censoft.censoftrongtong.domain.ProjectUserPost;
import com.github.yulichang.base.MPJBaseMapper;

/**
 * 项目用户岗位关系Mapper接口
 * 
 * @author ruoyi
 * @date 2023-11-30
 */
public interface ProjectUserPostMapper  extends MPJBaseMapper<ProjectUserPost>
{
    /**
     * 查询项目用户岗位关系
     * 
     * @param id 项目用户岗位关系主键
     * @return 项目用户岗位关系
     */
    public ProjectUserPost selectProjectUserPostById(Long id);

    /**
     * 查询项目用户岗位关系列表
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 项目用户岗位关系集合
     */
    public List<ProjectUserPost> selectProjectUserPostList(ProjectUserPost projectUserPost);

    /**
     * 新增项目用户岗位关系
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 结果
     */
    public int insertProjectUserPost(ProjectUserPost projectUserPost);

    /**
     * 修改项目用户岗位关系
     * 
     * @param projectUserPost 项目用户岗位关系
     * @return 结果
     */
    public int updateProjectUserPost(ProjectUserPost projectUserPost);

    /**
     * 删除项目用户岗位关系
     * 
     * @param id 项目用户岗位关系主键
     * @return 结果
     */
    public int deleteProjectUserPostById(Long id);

    /**
     * 批量删除项目用户岗位关系
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProjectUserPostByIds(Long[] ids);
}
