package com.censoft.censoftrongtong.controller;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.censoft.censoftrongtong.domain.CurrentRiskUserHoliday;
import com.censoft.censoftrongtong.service.ICurrentRiskUserHolidayService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 现状风险巡查用户请假Controller
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@RestController
@RequestMapping(value = {"/risk/currentRiskHoliday","/app-api/risk/currentRiskHoliday"})
public class CurrentRiskUserHolidayController extends BaseController
{
    @Autowired
    private ICurrentRiskUserHolidayService currentRiskUserHolidayService;

    /**
     * 查询现状风险巡查用户请假列表
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskHoliday:list')")
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskUserHoliday currentRiskUserHoliday)
    {
        startPage();
        List<CurrentRiskUserHoliday> list = currentRiskUserHolidayService.selectCurrentRiskUserHolidayList(currentRiskUserHoliday);
        return getDataTable(list);
    }

    /**
     * 导出现状风险巡查用户请假列表
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskHoliday:export')")
    @Log(title = "现状风险巡查用户请假", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskUserHoliday currentRiskUserHoliday)
    {
        List<CurrentRiskUserHoliday> list = currentRiskUserHolidayService.selectCurrentRiskUserHolidayList(currentRiskUserHoliday);
        ExcelUtil<CurrentRiskUserHoliday> util = new ExcelUtil<CurrentRiskUserHoliday>(CurrentRiskUserHoliday.class);
        util.exportExcel(response, list, "现状风险巡查用户请假数据");
    }

    /**
     * 获取现状风险巡查用户请假详细信息
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskHoliday:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(currentRiskUserHolidayService.selectCurrentRiskUserHolidayById(id));
    }

    /**
     * 新增现状风险巡查用户请假
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskHoliday:add')")
    @Log(title = "现状风险巡查用户请假", businessType = BusinessType.INSERT)
    @PostMapping("/save")
    public AjaxResult add(@RequestBody CurrentRiskUserHoliday currentRiskUserHoliday)
    {
        if(null == currentRiskUserHoliday.getId()){
            currentRiskUserHoliday.setApplyUserId(getUserId());
            currentRiskUserHoliday.setApplyTime(new Date());
            currentRiskUserHoliday.setStatus("0");
            //查询上级项目经理

            currentRiskUserHolidayService.insertCurrentRiskUserHoliday(currentRiskUserHoliday);
        }else{
            currentRiskUserHoliday.setApproveTime(new Date());
            currentRiskUserHolidayService.updateCurrentRiskUserHoliday(currentRiskUserHoliday);
        }
        return AjaxResult.success();
    }

    /**
     * 修改现状风险巡查用户请假
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskHoliday:edit')")
    @Log(title = "现状风险巡查用户请假", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskUserHoliday currentRiskUserHoliday)
    {
        return toAjax(currentRiskUserHolidayService.updateCurrentRiskUserHoliday(currentRiskUserHoliday));
    }

    /**
     * 删除现状风险巡查用户请假
     */
    @PreAuthorize("@ss.hasPermi('risk:currentRiskHoliday:remove')")
    @Log(title = "现状风险巡查用户请假", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(currentRiskUserHolidayService.deleteCurrentRiskUserHolidayByIds(ids));
    }
}
