package com.censoft.censoftrongtong.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.CurrentRiskPostList;
import com.censoft.censoftrongtong.domain.CurrentRiskPostListSaveVO;
import com.censoft.censoftrongtong.service.ICurrentRiskPostListService;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.censoft.censoftrongtong.domain.CurrentRiskPost;
import com.censoft.censoftrongtong.service.ICurrentRiskPostService;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 现状风险岗位Controller
 * 
 * @author ruoyi
 * @date 2023-12-01
 */
@RestController
@AllArgsConstructor
@RequestMapping("/system/currentRiskPost")
public class CurrentRiskPostController extends BaseController
{
    private ICurrentRiskPostService currentRiskPostService;
    private ICurrentRiskPostListService currentRiskPostListService;

    /**
     * 查询现状风险岗位列表
     */
    @PreAuthorize("@ss.hasPermi('system:currentRiskPost:list')")
    @GetMapping("/list")
    public TableDataInfo list(CurrentRiskPost currentRiskPost)
    {
        startPage();
        List<CurrentRiskPost> list = currentRiskPostService.selectCurrentRiskPostList(currentRiskPost);
        return getDataTable(list);
    }

    /**
     * 导出现状风险岗位列表
     */
    @PreAuthorize("@ss.hasPermi('system:currentRiskPost:export')")
    @Log(title = "现状风险岗位", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, CurrentRiskPost currentRiskPost)
    {
        List<CurrentRiskPost> list = currentRiskPostService.selectCurrentRiskPostList(currentRiskPost);
        ExcelUtil<CurrentRiskPost> util = new ExcelUtil<CurrentRiskPost>(CurrentRiskPost.class);
        util.exportExcel(response, list, "现状风险岗位数据");
    }

    /**
     * 获取现状风险岗位详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:currentRiskPost:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(currentRiskPostService.selectCurrentRiskPostById(id));
    }

    /**
     * 新增现状风险岗位
     */
    @PreAuthorize("@ss.hasPermi('system:currentRiskPost:add')")
    @Log(title = "现状风险岗位", businessType = BusinessType.INSERT)
    @PostMapping("save")
    public AjaxResult add(@RequestBody CurrentRiskPost currentRiskPost)
    {
        Long currentRiskPostId = currentRiskPost.getId();
        if(currentRiskPostId == null){
            int id = currentRiskPostService.insertCurrentRiskPost(currentRiskPost);
            currentRiskPostId = currentRiskPost.getId();
        }else{
            currentRiskPostService.updateCurrentRiskPost(currentRiskPost);
            //删除原有岗位用户信息
            QueryWrapper<CurrentRiskPostList> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("post_id",currentRiskPostId);
            currentRiskPostListService.remove(queryWrapper);
        }
        //新增清单列表
        List<CurrentRiskPostListSaveVO> list = currentRiskPost.getList();
        if(!CollectionUtils.isEmpty(list)){
            String userIds = currentRiskPost.getUserId();
            for(String userId :userIds.split(",")){
                List<CurrentRiskPostList> currentRiskPostLists = new ArrayList<>();
                Long finalCurrentRiskPostId = currentRiskPostId;
                list.forEach(vo ->{
                    //0 一岗一人 1 一岗多人
                    if("1".equals(currentRiskPost.getPatrolType()) && Long.parseLong(userId) != vo.getUserId()){
                        return;
                    }
                    CurrentRiskPostList currentRiskPostList = new CurrentRiskPostList();
                    currentRiskPostList.setProjectId(currentRiskPost.getProjectId());
                    currentRiskPostList.setPostId(finalCurrentRiskPostId);
                    currentRiskPostList.setUserId(Long.parseLong(userId));
                    currentRiskPostList.setCurrentRiskId(vo.getId());
                    currentRiskPostList.setPatrolType(vo.getPatrolType());
                    currentRiskPostList.setCreateTime(new Date());
                    currentRiskPostLists.add(currentRiskPostList);
                });
                if(!CollectionUtils.isEmpty(currentRiskPostLists)){
                    currentRiskPostListService.saveBatch(currentRiskPostLists);
                }
            }
        }
        return AjaxResult.success();
    }

    /**
     * 修改现状风险岗位
     */
    @PreAuthorize("@ss.hasPermi('system:currentRiskPost:edit')")
    @Log(title = "现状风险岗位", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody CurrentRiskPost currentRiskPost)
    {
        return toAjax(currentRiskPostService.updateCurrentRiskPost(currentRiskPost));
    }

    /**
     * 删除现状风险岗位
     */
    @PreAuthorize("@ss.hasPermi('system:currentRiskPost:remove')")
    @Log(title = "现状风险岗位", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(currentRiskPostService.deleteCurrentRiskPostByIds(ids));
    }
}
