package com.censoft.censoftrongtong.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;

import com.censoft.censoftrongtong.domain.RiskPlan;
import com.censoft.censoftrongtong.domain.RiskPlanTask;
import com.censoft.censoftrongtong.enums.RiskPlanStatusType;
import com.censoft.censoftrongtong.mapper.RiskPlanMapper;
import com.censoft.censoftrongtong.service.IRiskPlanService;
import com.censoft.censoftrongtong.service.IRiskPlanTaskService;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 风险计划Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanServiceImpl implements IRiskPlanService {
    @Autowired
    private RiskPlanMapper riskPlanMapper;

    @Resource
    private IRiskPlanTaskService riskPlanTaskService;

    /**
     * 查询风险计划
     *
     * @param id 风险计划主键
     * @return 风险计划
     */
    @Override
    public RiskPlan selectRiskPlanById(Long id) {
        return riskPlanMapper.selectRiskPlanById(id);
    }

    /**
     * 查询风险计划列表
     *
     * @param riskPlan 风险计划
     * @return 风险计划
     */
    @Override
    public List<RiskPlan> selectRiskPlanList(RiskPlan riskPlan) {
        return riskPlanMapper.selectRiskPlanList(riskPlan);
    }

    /**
     * 新增风险计划
     *
     * @param riskPlan 风险计划
     * @return 结果
     */
    @Override
    public int insertRiskPlan(RiskPlan riskPlan) {
        riskPlan.setCreateTime(DateUtils.getNowDate());
        return riskPlanMapper.insertRiskPlan(riskPlan);
    }

    /**
     * 修改风险计划
     *
     * @param riskPlan 风险计划
     * @return 结果
     */
    @Override
    public int updateRiskPlan(RiskPlan riskPlan) {
        riskPlan.setUpdateTime(DateUtils.getNowDate());
        return riskPlanMapper.updateRiskPlan(riskPlan);
    }

    /**
     * 批量删除风险计划
     *
     * @param ids 需要删除的风险计划主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanByIds(Long[] ids) {
        return riskPlanMapper.deleteRiskPlanByIds(ids);
    }

    /**
     * 删除风险计划信息
     *
     * @param id 风险计划主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanById(Long id) {
        return riskPlanMapper.deleteRiskPlanById(id);
    }

    @Override
    public int saveRiskPlan(RiskPlan riskPlan) {
        //插入主表
        riskPlan.setNo(getNo());
        riskPlan.setStatus(RiskPlanStatusType.RUNNING.getStatus());
        int i = insertRiskPlan(riskPlan);

        //插入任务表 已完成任务发起
        RiskPlanTask riskPlanTask = new RiskPlanTask();
        riskPlanTask.setPlanId(riskPlan.getId());
        riskPlanTask.setTaskKey(RiskPlanStatusType.WAIT_START.getStatus());
        riskPlanTask.setTaskName(RiskPlanStatusType.getTitleByStatus(RiskPlanStatusType.WAIT_START.getStatus()));
        riskPlanTask.setStatus("completed");
        riskPlanTask.setStartTime(new Date());
        riskPlanTask.setCompletedTime(new Date());
        riskPlanTaskService.insertRiskPlanTask(riskPlanTask);

        //插入任务表 待执行风险评估
        RiskPlanTask riskPlanTask1 = new RiskPlanTask();
        riskPlanTask1.setPlanId(riskPlan.getId());
        riskPlanTask1.setApprovalUserId(riskPlan.getLeaderUserId());
        riskPlanTask1.setTaskKey(RiskPlanStatusType.RUNNING.getStatus());
        riskPlanTask1.setTaskName(RiskPlanStatusType.getTitleByStatus(RiskPlanStatusType.RUNNING.getStatus()));
        riskPlanTask1.setStatus("running");
        riskPlanTask1.setStartTime(new Date());
        riskPlanTaskService.insertRiskPlanTask(riskPlanTask1);
        return i;
    }

    private String getNo() {
        Random random = new Random();
        int randomNumber = random.nextInt(1000); // 生成0到999之间的随机数
        String formattedNumber = String.format("%03d", randomNumber); // 格式化为三位数，不足三位前面补0
        return DateUtils.dateTimeNow() + formattedNumber;
    }
}
