package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.censoft.censoftrongtong.domain.LawList;
import com.censoft.censoftrongtong.domain.RiskSignRecord;
import com.censoft.censoftrongtong.mapper.LawListMapper;
import com.censoft.censoftrongtong.mapper.RiskSignRecordMapper;
import com.censoft.censoftrongtong.service.ILawListService;
import com.censoft.censoftrongtong.service.IRiskSignRecordService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 签到签退记录表Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskSignRecordServiceImpl
        extends MPJBaseServiceImpl<RiskSignRecordMapper, RiskSignRecord>
        implements IRiskSignRecordService {
    @Autowired
    private RiskSignRecordMapper riskSignRecordMapper;


    @Override
    public List<RiskSignRecord> getSignList(RiskSignRecord riskSignRecord) {
        LambdaQueryWrapper<RiskSignRecord> queryWrapper = new LambdaQueryWrapper<>();
        if (riskSignRecord.getType() != null) {
            queryWrapper = queryWrapper.eq(RiskSignRecord::getType,riskSignRecord.getType());
        }
        if (riskSignRecord.getUserId() != null) {
            queryWrapper = queryWrapper.eq(RiskSignRecord::getUserId,riskSignRecord.getUserId());
        }
        queryWrapper = queryWrapper.orderByAsc(RiskSignRecord::getCreateTime);
        return list(queryWrapper);
    }

    /**
     * 查询签到签退记录
     *
     * @param id 签到签退记录主键
     * @return 签到签退记录
     */
    @Override
    public RiskSignRecord selectRiskSignRecordById(Long id)
    {
        return riskSignRecordMapper.selectRiskSignRecordById(id);
    }

    /**
     * 查询签到签退记录列表
     *
     * @param riskSignRecord 签到签退记录
     * @return 签到签退记录
     */
    @Override
    public List<RiskSignRecord> selectRiskSignRecordList(RiskSignRecord riskSignRecord)
    {
        return riskSignRecordMapper.selectRiskSignRecordList(riskSignRecord);
    }

    /**
     * 新增签到签退记录
     *
     * @param riskSignRecord 签到签退记录
     * @return 结果
     */
    @Override
    public int insertRiskSignRecord(RiskSignRecord riskSignRecord)
    {
        riskSignRecord.setCreateTime(DateUtils.getNowDate());
        return riskSignRecordMapper.insertRiskSignRecord(riskSignRecord);
    }

    /**
     * 修改签到签退记录
     *
     * @param riskSignRecord 签到签退记录
     * @return 结果
     */
    @Override
    public int updateRiskSignRecord(RiskSignRecord riskSignRecord)
    {
        riskSignRecord.setUpdateTime(DateUtils.getNowDate());
        return riskSignRecordMapper.updateRiskSignRecord(riskSignRecord);
    }

    /**
     * 批量删除签到签退记录
     *
     * @param ids 需要删除的签到签退记录主键
     * @return 结果
     */
    @Override
    public int deleteRiskSignRecordByIds(Long[] ids)
    {
        return riskSignRecordMapper.deleteRiskSignRecordByIds(ids);
    }

    /**
     * 删除签到签退记录信息
     *
     * @param id 签到签退记录主键
     * @return 结果
     */
    @Override
    public int deleteRiskSignRecordById(Long id)
    {
        return riskSignRecordMapper.deleteRiskSignRecordById(id);
    }

}
