package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.RiskSignRecord;
import com.github.yulichang.base.MPJBaseService;

import java.util.List;

/**
 * 签到签退记录表Service接口
 *
 * @author ruoyi
 * @date 2023-08-31
 */
public interface IRiskSignRecordService extends MPJBaseService<RiskSignRecord> {

    List<RiskSignRecord> getSignList(RiskSignRecord riskSignRecord);


    /**
     * 查询签到签退记录
     *
     * @param id 签到签退记录主键
     * @return 签到签退记录
     */
    public RiskSignRecord selectRiskSignRecordById(Long id);

    /**
     * 查询签到签退记录列表
     *
     * @param riskSignRecord 签到签退记录
     * @return 签到签退记录集合
     */
    public List<RiskSignRecord> selectRiskSignRecordList(RiskSignRecord riskSignRecord);

    /**
     * 新增签到签退记录
     *
     * @param riskSignRecord 签到签退记录
     * @return 结果
     */
    public int insertRiskSignRecord(RiskSignRecord riskSignRecord);

    /**
     * 修改签到签退记录
     *
     * @param riskSignRecord 签到签退记录
     * @return 结果
     */
    public int updateRiskSignRecord(RiskSignRecord riskSignRecord);

    /**
     * 批量删除签到签退记录
     *
     * @param ids 需要删除的签到签退记录主键集合
     * @return 结果
     */
    public int deleteRiskSignRecordByIds(Long[] ids);

    /**
     * 删除签到签退记录信息
     *
     * @param id 签到签退记录主键
     * @return 结果
     */
    public int deleteRiskSignRecordById(Long id);

}
