package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.LedgerBuilding;
import com.censoft.censoftrongtong.mapper.LedgerBuildingMapper;
import com.censoft.censoftrongtong.service.ILedgerBuildingService;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 基础数据-楼宇Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class LedgerBuildingServiceImpl implements ILedgerBuildingService
{
    @Autowired
    private LedgerBuildingMapper ledgerBuildingMapper;

    /**
     * 查询基础数据-楼宇
     * 
     * @param id 基础数据-楼宇主键
     * @return 基础数据-楼宇
     */
    @Override
    public LedgerBuilding selectLedgerBuildingById(Long id)
    {
        return ledgerBuildingMapper.selectLedgerBuildingById(id);
    }

    /**
     * 查询基础数据-楼宇列表
     * 
     * @param ledgerBuilding 基础数据-楼宇
     * @return 基础数据-楼宇
     */
    @Override
    public List<LedgerBuilding> selectLedgerBuildingList(LedgerBuilding ledgerBuilding)
    {
        return ledgerBuildingMapper.selectLedgerBuildingList(ledgerBuilding);
    }

    /**
     * 新增基础数据-楼宇
     * 
     * @param ledgerBuilding 基础数据-楼宇
     * @return 结果
     */
    @Override
    public int insertLedgerBuilding(LedgerBuilding ledgerBuilding)
    {
        ledgerBuilding.setCreateTime(DateUtils.getNowDate());
        return ledgerBuildingMapper.insertLedgerBuilding(ledgerBuilding);
    }

    /**
     * 修改基础数据-楼宇
     * 
     * @param ledgerBuilding 基础数据-楼宇
     * @return 结果
     */
    @Override
    public int updateLedgerBuilding(LedgerBuilding ledgerBuilding)
    {
        ledgerBuilding.setUpdateTime(DateUtils.getNowDate());
        return ledgerBuildingMapper.updateLedgerBuilding(ledgerBuilding);
    }

    /**
     * 批量删除基础数据-楼宇
     * 
     * @param ids 需要删除的基础数据-楼宇主键
     * @return 结果
     */
    @Override
    public int deleteLedgerBuildingByIds(Long[] ids)
    {
        return ledgerBuildingMapper.deleteLedgerBuildingByIds(ids);
    }

    /**
     * 删除基础数据-楼宇信息
     * 
     * @param id 基础数据-楼宇主键
     * @return 结果
     */
    @Override
    public int deleteLedgerBuildingById(Long id)
    {
        return ledgerBuildingMapper.deleteLedgerBuildingById(id);
    }
}
