package com.censoft.censoftrongtong.service;

import com.censoft.censoftrongtong.domain.LedgerProject;
import com.github.yulichang.base.MPJBaseService;
import com.ruoyi.common.core.domain.entity.SysUser;

import java.util.List;

/**
 * 基础数据-项目Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface ILedgerProjectService extends MPJBaseService<LedgerProject>
{
    /**
     * 查询基础数据-项目
     * 
     * @param id 基础数据-项目主键
     * @return 基础数据-项目
     */
    public LedgerProject selectLedgerProjectById(Long id);

    /**
     * 查询基础数据-项目列表
     * 
     * @param ledgerProject 基础数据-项目
     * @return 基础数据-项目集合
     */
    public List<LedgerProject> selectLedgerProjectList(LedgerProject ledgerProject);

    /**
     * 新增基础数据-项目
     * 
     * @param ledgerProject 基础数据-项目
     * @return 结果
     */
    public int insertLedgerProject(LedgerProject ledgerProject);

    /**
     * 修改基础数据-项目
     * 
     * @param ledgerProject 基础数据-项目
     * @return 结果
     */
    public int updateLedgerProject(LedgerProject ledgerProject);

    /**
     * 批量删除基础数据-项目
     * 
     * @param ids 需要删除的基础数据-项目主键集合
     * @return 结果
     */
    public int deleteLedgerProjectByIds(Long[] ids);

    /**
     * 删除基础数据-项目信息
     * 
     * @param id 基础数据-项目主键
     * @return 结果
     */
    public int deleteLedgerProjectById(Long id);

    /**
     * 查询自身及以下项目列表
     *
     * @param ledgerProject 基础数据-项目
     * @return 基础数据-项目集合
     */
    public List<LedgerProject>  getProjectListByDeptId(LedgerProject ledgerProject);

    /**
     * 获取部门下的所有人员
     *
     * @param deptId 项目id
     * @return 人员list
     */
    public List<SysUser>  getUserListByDeptId(Long deptId);
}
