package com.censoft.censoftrongtong.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.censoft.censoftrongtong.domain.LedgerBuilding;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.censoft.censoftrongtong.service.ILedgerBuildingService;
import com.censoft.censoftrongtong.service.ILedgerProjectService;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.R;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 首页相关接口Controller
 *
 * @author ruoyi
 * @date 2023-03-20
 */
@Api(tags = {"首页统计相关接口"})
@RestController
@RequestMapping("/system/index")
@AllArgsConstructor
public class IndexController extends BaseController {

    @Resource
    ILedgerProjectService ledgerProjectService;
    @Resource
    ILedgerBuildingService ledgerBuildingService;


    /**
     * 项目,楼栋,楼层和房间数据统计
     */

    @ApiOperation("项目,楼栋,楼层和房间数据统计")
    @GetMapping("/getBaseInfoNum")
    public R getBaseInfoNum() {

        int projectCount = 0;//项目数量
        int buildingCount = 0;//楼栋数量
        int floorCount = 0;//楼层数量
        int roomCount = 0;//房间数

        Map<String, String> map_gk = new HashMap<>();
        map_gk.put("projectNum", projectCount + "");
        map_gk.put("buildingNum", buildingCount + "");
        map_gk.put("floorNum", floorCount + "");
        map_gk.put("roomNum", roomCount + "");
        return R.ok(map_gk);
    }

    /**
     * 项目按照不同纬度统计
     */

    @ApiOperation("项目按照不同纬度统计")
    @GetMapping("/getProjectNumByType")
    public R getProjectNumByType() {


        Map<String, Object> map_rs = new HashMap<>();
        List<Map<String,String>> list_rs=new ArrayList<>();
        List<String> legendList=new ArrayList<>();
        QueryWrapper<LedgerProject> queryWrap=new QueryWrapper<>();
        queryWrap.select("count(*) 'num'","city").groupBy("city");
        List<LedgerProject> list=ledgerProjectService.list(queryWrap);
        if (list!=null&&list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                Map<String,String> map_item=new HashMap<>();
                LedgerProject ledgerProject=list.get(i);
                map_item.put("name",ledgerProject.getCity());
                map_item.put("value",ledgerProject.getNum());
                list_rs.add(map_item);
                legendList.add(ledgerProject.getCity());
            }
        }
        map_rs.put("legendData",legendList);
        map_rs.put("seriesData",list_rs);

        MPJLambdaWrapper<LedgerBuilding> queryWrapper=new MPJLambdaWrapper<>();
        queryWrapper.selectAll(LedgerBuilding.class).leftJoin(LedgerProject.class,LedgerProject::getId,LedgerBuilding::getProjectId)
                .eq(LedgerBuilding::getProjectId,1);
        List<LedgerBuilding> list1=ledgerBuildingService.selectJoinList(LedgerBuilding.class,queryWrapper);









        return R.ok(map_rs);
    }




}
