package com.censoft.censoftrongtong.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.dto.RiskExistingListSaveDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDetailsDto;

import java.util.List;

/**
 * 现有风险清单库Service接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface IRiskPlanExistingListService  extends IService<RiskPlanExistingList>
{

    /**
     * 查询现有风险清单库
     *
     * @param id 现有风险清单库主键
     * @return 现有风险清单库
     */
    public RiskPlanExistingList selectRiskPlanExistingListById(Long id);

    /**
     * 查询现有风险清单库列表
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 现有风险清单库集合
     */
    public List<RiskPlanExistingList> selectRiskPlanExistingListList(RiskPlanExistingList riskPlanExistingList);

    /**
     * 新增现有风险清单库
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    public int insertRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList);

    /**
     * 修改现有风险清单库
     *
     * @param riskPlanExistingList 现有风险清单库
     * @return 结果
     */
    public int updateRiskPlanExistingList(RiskPlanExistingList riskPlanExistingList);

    /**
     * 批量删除现有风险清单库
     *
     * @param ids 需要删除的现有风险清单库主键集合
     * @return 结果
     */
    public int deleteRiskPlanExistingListByIds(Long[] ids);

    /**
     * 删除现有风险清单库信息
     *
     * @param id 现有风险清单库主键
     * @return 结果
     */
    public int deleteRiskPlanExistingListById(Long id);

    Boolean saveRiskExistingListSaveDto(RiskExistingListSaveDto saveDto);
    RiskPlanAppExistingListDetailsDto getRiskPlanAppExistingListDetailsDtoByExistingId(Long existingId);
}
