package com.ruoyi.web.controller.app;

import com.censoft.censoftrongtong.domain.*;
import com.censoft.censoftrongtong.domain.dto.*;
import com.censoft.censoftrongtong.enums.RiskPlanStatusType;
import com.censoft.censoftrongtong.service.*;
import com.ruoyi.common.config.RuoYiConfig;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.domain.entity.SysDictData;
import com.ruoyi.common.core.domain.entity.SysMenu;
import com.ruoyi.common.core.domain.entity.SysUser;
import com.ruoyi.common.core.domain.model.LoginUser;
import com.ruoyi.system.service.ISysDictDataService;
import com.ruoyi.system.service.ISysMenuService;
import com.ruoyi.system.service.ISysUploadFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 菜单app端接口
 *
 * @author censoft
 * @date 2023-06-27
 * @module 融通项目
 */
@RestController
@RequestMapping("/app-api/menu")
public class SysMenuAppController extends BaseController {

    @Autowired
    private ISysMenuService menuService;

    /**
     * 菜单栏
     *
     * @param httpServletRequest
     * @return
     */
    @GetMapping("/getMenu")
    @ResponseBody
    public AjaxResult menu(HttpServletRequest httpServletRequest) {
        SysMenu menu = new SysMenu();
        menu.setParentId(2055L);
        menu.getParams().put("userId", getUserId());
        Map menus = new HashMap<>();
        if (SysUser.isAdmin(getUserId())) {
            menu.getParams().put("isAdmin", true);
        }
        List<SysMenu> title = menuService.selectMenusApp(menu);
        for (int i = 0; i < title.size(); i++) {
            menu.setParentId(title.get(i).getMenuId());
            List<SysMenu> menus1 = menuService.selectMenusApp(menu);
            menus.put(title.get(i).getMenuName(), menus1);
        }
        return AjaxResult.success(menus);
    }
}
