package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.censoft.censoftrongtong.domain.RiskAssessmentMatrixScore;
import com.censoft.censoftrongtong.mapper.RiskAssessmentMatrixScoreMapper;
import com.censoft.censoftrongtong.service.IRiskAssessmentMatrixScoreService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 基础数据-楼层Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskAssessmentMatrixScoreServiceImpl
        extends ServiceImpl<RiskAssessmentMatrixScoreMapper, RiskAssessmentMatrixScore>
        implements IRiskAssessmentMatrixScoreService {


    @Override
    public List<RiskAssessmentMatrixScore> getRiskAssessmentMatrixScoreListByType(String type) {
        LambdaQueryWrapper<RiskAssessmentMatrixScore> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(RiskAssessmentMatrixScore::getType, type).orderByAsc(RiskAssessmentMatrixScore::getSort);
        return list(wrapper);
    }
}
