package com.censoft.censoftrongtong.controller;

import com.censoft.censoftrongtong.domain.EvaluationFactorItems;
import com.censoft.censoftrongtong.service.IEvaluationFactorItemsService;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.core.page.TableDataInfo;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 评估选项管理Controller
 * 
 * @author xjchen
 * @date 2023-08-08
 */
@RestController
@RequestMapping("/evaluation/items")
public class EvaluationFactorItemsController extends BaseController
{
    @Autowired
    private IEvaluationFactorItemsService evaluationFactorItemsService;

    /**
     * 查询评估选项管理列表
     */
    @PreAuthorize("@ss.hasPermi('evaluation:items:list')")
    @GetMapping("/list")
    public TableDataInfo list(EvaluationFactorItems evaluationFactorItems)
    {
        startPage();
        List<EvaluationFactorItems> list = evaluationFactorItemsService.selectEvaluationFactorItemsList(evaluationFactorItems);
        return getDataTable(list);
    }

    /**
     * 导出评估选项管理列表
     */
    @PreAuthorize("@ss.hasPermi('evaluation:items:export')")
    @Log(title = "评估选项管理", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, EvaluationFactorItems evaluationFactorItems)
    {
        List<EvaluationFactorItems> list = evaluationFactorItemsService.selectEvaluationFactorItemsList(evaluationFactorItems);
        ExcelUtil<EvaluationFactorItems> util = new ExcelUtil<EvaluationFactorItems>(EvaluationFactorItems.class);
        util.exportExcel(response, list, "评估选项管理数据");
    }

    /**
     * 获取评估选项管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('evaluation:items:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(evaluationFactorItemsService.selectEvaluationFactorItemsById(id));
    }

    /**
     * 新增评估选项管理
     */
    @PreAuthorize("@ss.hasPermi('evaluation:items:add')")
    @Log(title = "评估选项管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody EvaluationFactorItems evaluationFactorItems)
    {
        return toAjax(evaluationFactorItemsService.insertEvaluationFactorItems(evaluationFactorItems));
    }

    /**
     * 修改评估选项管理
     */
    @PreAuthorize("@ss.hasPermi('evaluation:items:edit')")
    @Log(title = "评估选项管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody EvaluationFactorItems evaluationFactorItems)
    {
        return toAjax(evaluationFactorItemsService.updateEvaluationFactorItems(evaluationFactorItems));
    }

    /**
     * 删除评估选项管理
     */
    @PreAuthorize("@ss.hasPermi('evaluation:items:remove')")
    @Log(title = "评估选项管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(evaluationFactorItemsService.deleteEvaluationFactorItemsByIds(ids));
    }
}
