package com.censoft.censoftrongtong.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.censoft.censoftrongtong.domain.RiskPlanExistingList;
import com.censoft.censoftrongtong.domain.dto.RiskExistingListSaveDto;
import com.censoft.censoftrongtong.mapper.RiskPlanExistingListMapper;
import com.censoft.censoftrongtong.service.IRiskPlanExistingListService;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 现有风险清单库Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanExistingListServiceImpl
        extends ServiceImpl<RiskPlanExistingListMapper, RiskPlanExistingList>
        implements IRiskPlanExistingListService {
    @Autowired
    private RiskPlanExistingListMapper riskPlanExistingListMapper;

    @Override
    public Boolean saveRiskExistingListSaveDto(RiskExistingListSaveDto saveDto) {
        RiskPlanExistingList existingList = new RiskPlanExistingList();
        BeanUtils.copyProperties(saveDto, existingList);
        return save(existingList);
    }
}
