package com.censoft.censoftrongtong.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import cn.hutool.core.util.StrUtil;
import com.censoft.censoftrongtong.domain.RiskPlanInherentList;
import com.censoft.censoftrongtong.domain.dto.RiskInherentListSaveDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppExistingListDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDetailsDto;
import com.censoft.censoftrongtong.domain.dto.RiskPlanAppInherentListDto;
import com.censoft.censoftrongtong.mapper.RiskPlanInherentListMapper;
import com.censoft.censoftrongtong.service.IRiskPlanInherentListService;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.service.ISysUploadFileService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.hutool.core.date.DateUnit;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;

/**
 * 固有风险清单库Service业务层处理
 *
 * @author ruoyi
 * @date 2023-06-26
 */
@Service
public class RiskPlanInherentListServiceImpl implements IRiskPlanInherentListService {
    @Autowired
    private RiskPlanInherentListMapper riskPlanInherentListMapper;

    @Resource
    private ISysUploadFileService uploadFileService;

    /**
     * 查询固有风险清单库
     *
     * @param id 固有风险清单库主键
     * @return 固有风险清单库
     */
    @Override
    public RiskPlanInherentList selectRiskPlanInherentListById(Long id) {
        return riskPlanInherentListMapper.selectRiskPlanInherentListById(id);
    }

    /**
     * 查询固有风险清单库列表
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 固有风险清单库
     */
    @Override
    public List<RiskPlanInherentList> selectRiskPlanInherentListList(RiskPlanInherentList riskPlanInherentList) {
        return riskPlanInherentListMapper.selectRiskPlanInherentListList(riskPlanInherentList);
    }

    /**
     * 新增固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int insertRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList) {
        riskPlanInherentList.setCreateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.insertRiskPlanInherentList(riskPlanInherentList);
    }

    /**
     * 修改固有风险清单库
     *
     * @param riskPlanInherentList 固有风险清单库
     * @return 结果
     */
    @Override
    public int updateRiskPlanInherentList(RiskPlanInherentList riskPlanInherentList) {
        riskPlanInherentList.setUpdateTime(DateUtils.getNowDate());
        return riskPlanInherentListMapper.updateRiskPlanInherentList(riskPlanInherentList);
    }

    /**
     * 批量删除固有风险清单库
     *
     * @param ids 需要删除的固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanInherentListByIds(Long[] ids) {
        return riskPlanInherentListMapper.deleteRiskPlanInherentListByIds(ids);
    }

    /**
     * 删除固有风险清单库信息
     *
     * @param id 固有风险清单库主键
     * @return 结果
     */
    @Override
    public int deleteRiskPlanInherentListById(Long id) {
        return riskPlanInherentListMapper.deleteRiskPlanInherentListById(id);
    }

    @Override
    public List<RiskPlanAppInherentListDto> getInherentListByPlanId(Long planId, Long buildingId, Long floorId, Long roomId) {
        return riskPlanInherentListMapper.getInherentListByPlanId(planId, buildingId, floorId, roomId);
    }

    @Override
    public Integer saveRiskInherentListSaveDto(RiskInherentListSaveDto saveDto) {
        RiskPlanInherentList inherentList = new RiskPlanInherentList();
        BeanUtils.copyProperties(saveDto, inherentList);
        return insertRiskPlanInherentList(inherentList);
    }

    @Override
    public RiskPlanAppInherentListDetailsDto getRiskPlanAppInherentListDetailsDtoByInherentId(Long inherentId) {
        RiskPlanAppInherentListDetailsDto dto = riskPlanInherentListMapper.getRiskPlanAppInherentListDetailsDtoByInherentId(inherentId);

        //风险源照片
        if (!StrUtil.hasEmpty(dto.getPictureFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getPictureFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setPictureFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //工程技术措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresProjectFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresProjectFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresProjectFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //管理措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresAdministrationFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresAdministrationFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresAdministrationFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        //应急处置措施附件
        if (!StrUtil.hasEmpty(dto.getMeasuresEmergencyFileIds())) {
            List<Long> fileIds = Arrays.stream(dto.getMeasuresEmergencyFileIds().split(","))
                    .map(Long::parseLong)
                    .collect(Collectors.toList());
            dto.setMeasuresEmergencyFile(uploadFileService.selectSysFileByFileIds(fileIds));
        }
        return dto;
    }

    @Override
    public List<RiskPlanAppExistingListDto> getExistingListByInherentId(Long inherentId) {
        return riskPlanInherentListMapper.getExistingListByInherentId(inherentId);
    }
}
