package com.censoft.censoftrongtong.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 计划人员与楼宇关系表 risk_plan_user_building
 *
 * @author ruoyi
 * @date 2023-07-05
 */
@Data
@TableName("risk_plan_user_building")
public class RiskPlanUserBuilding {

    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 计划id
     */
    @TableField("plan_id")
    private Long planId;

    /**
     * 楼宇id
     */
    @TableField("building_id")
    private Long buildingId;

    /**
     * 处理人员ids
     */
    @TableField("user_ids")
    private String userIds;

    /**
     * 发起时间
     */
    @TableField("start_time")
    private Date startTime;

    /**
     * 结束时间
     */
    @TableField("finish_time")
    private Date finishTime;

    /**
     * 执行状态
     */
    @TableField("status")
    private String status;

}
