package com.censoft.censoftrongtong.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.censoft.censoftrongtong.domain.LawList;
import com.censoft.censoftrongtong.service.ILawListService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.AjaxResult;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 法律法规库Controller
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
@RestController
@RequestMapping("/system/law/list")
public class LawListController extends BaseController
{
    @Autowired
    private ILawListService lawListService;

    /**
     * 查询法律法规库列表
     */
    @PreAuthorize("@ss.hasPermi('system:law:list')")
    @GetMapping("/list")
    public TableDataInfo list(LawList lawList)
    {
        startPage();
        List<LawList> list = lawListService.selectLawListList(lawList);
        return getDataTable(list);
    }

    /**
     * 导出法律法规库列表
     */
    @PreAuthorize("@ss.hasPermi('system:law:export')")
    @Log(title = "法律法规库", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, LawList lawList)
    {
        List<LawList> list = lawListService.selectLawListList(lawList);
        ExcelUtil<LawList> util = new ExcelUtil<LawList>(LawList.class);
        util.exportExcel(response, list, "法律法规库数据");
    }

    /**
     * 获取法律法规库详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:law:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(lawListService.selectLawListById(id));
    }

    /**
     * 新增法律法规库
     */
    @PreAuthorize("@ss.hasPermi('system:law:add')")
    @Log(title = "法律法规库", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody LawList lawList)
    {
        return toAjax(lawListService.insertLawList(lawList));
    }

    /**
     * 修改法律法规库
     */
    @PreAuthorize("@ss.hasPermi('system:law:edit')")
    @Log(title = "法律法规库", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody LawList lawList)
    {
        return toAjax(lawListService.updateLawList(lawList));
    }

    /**
     * 删除法律法规库
     */
    @PreAuthorize("@ss.hasPermi('system:law:remove')")
    @Log(title = "法律法规库", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(lawListService.deleteLawListByIds(ids));
    }
}
