package com.censoft.censoftrongtong.mapper;

import com.censoft.censoftrongtong.domain.LedgerProject;

import java.util.List;

/**
 * 基础数据-项目Mapper接口
 * 
 * @author ruoyi
 * @date 2023-06-26
 */
public interface LedgerProjectMapper 
{
    /**
     * 查询基础数据-项目
     * 
     * @param id 基础数据-项目主键
     * @return 基础数据-项目
     */
    public LedgerProject selectLedgerProjectById(Long id);

    /**
     * 查询基础数据-项目列表
     * 
     * @param ledgerProject 基础数据-项目
     * @return 基础数据-项目集合
     */
    public List<LedgerProject> selectLedgerProjectList(LedgerProject ledgerProject);

    /**
     * 新增基础数据-项目
     * 
     * @param ledgerProject 基础数据-项目
     * @return 结果
     */
    public int insertLedgerProject(LedgerProject ledgerProject);

    /**
     * 修改基础数据-项目
     * 
     * @param ledgerProject 基础数据-项目
     * @return 结果
     */
    public int updateLedgerProject(LedgerProject ledgerProject);

    /**
     * 删除基础数据-项目
     * 
     * @param id 基础数据-项目主键
     * @return 结果
     */
    public int deleteLedgerProjectById(Long id);

    /**
     * 批量删除基础数据-项目
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteLedgerProjectByIds(Long[] ids);

    List<LedgerProject> getProjectListByDeptId(LedgerProject ledgerProject);
}
