package com.censoft.censoftrongtong.service.impl;

import java.util.*;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.censoft.censoftrongtong.domain.InfoAssets;
import com.censoft.censoftrongtong.domain.InfoLedger;
import com.censoft.censoftrongtong.domain.LedgerBuilding;
import com.censoft.censoftrongtong.domain.LedgerProject;
import com.censoft.censoftrongtong.domain.dto.InfoResultDto;
import com.censoft.censoftrongtong.mapper.InfoLedgerMapper;
import com.censoft.censoftrongtong.service.IInfoLedgerService;
import com.censoft.censoftrongtong.service.ILedgerBuildingService;
import com.censoft.censoftrongtong.service.ILedgerProjectService;
import com.ruoyi.common.core.domain.entity.SysDept;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.system.service.ISysDeptService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.github.yulichang.base.MPJBaseServiceImpl;

import javax.annotation.Resource;

/**
 * 数据中台资产项目数据Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-10-07
 */
@Service
public class InfoLedgerServiceImpl extends MPJBaseServiceImpl<InfoLedgerMapper, InfoLedger> implements IInfoLedgerService
{
    @Autowired
    private InfoLedgerMapper infoLedgerMapper;

    @Resource
    private ILedgerProjectService ledgerProjectService;

    @Resource
    private ISysDeptService sysDeptService;

    /**
     * 查询数据中台资产项目数据
     * 
     * @param id 数据中台资产项目数据主键
     * @return 数据中台资产项目数据
     */
    @Override
    public InfoLedger selectInfoLedgerById(String id)
    {
        return infoLedgerMapper.selectInfoLedgerById(id);
    }

    /**
     * 查询数据中台资产项目数据列表
     * 
     * @param infoLedger 数据中台资产项目数据
     * @return 数据中台资产项目数据
     */
    @Override
    public List<InfoLedger> selectInfoLedgerList(InfoLedger infoLedger)
    {
        return infoLedgerMapper.selectInfoLedgerList(infoLedger);
    }

    /**
     * 新增数据中台资产项目数据
     * 
     * @param infoLedger 数据中台资产项目数据
     * @return 结果
     */
    @Override
    public int insertInfoLedger(InfoLedger infoLedger)
    {
        return infoLedgerMapper.insertInfoLedger(infoLedger);
    }

    /**
     * 修改数据中台资产项目数据
     * 
     * @param infoLedger 数据中台资产项目数据
     * @return 结果
     */
    @Override
    public int updateInfoLedger(InfoLedger infoLedger)
    {
        return infoLedgerMapper.updateInfoLedger(infoLedger);
    }

    /**
     * 批量删除数据中台资产项目数据
     * 
     * @param ids 需要删除的数据中台资产项目数据主键
     * @return 结果
     */
    @Override
    public int deleteInfoLedgerByIds(String[] ids)
    {
        return infoLedgerMapper.deleteInfoLedgerByIds(ids);
    }

    /**
     * 删除数据中台资产项目数据信息
     * 
     * @param id 数据中台资产项目数据主键
     * @return 结果
     */
    @Override
    public int deleteInfoLedgerById(String id)
    {
        return infoLedgerMapper.deleteInfoLedgerById(id);
    }

    @Override
    public String saveOrUpdateByHttp() {
        //获取全部数据
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("create_time", DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));
        paramMap.put("update_time", DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss"));
        paramMap.put("pageSize", "1");
        paramMap.put("pageNum", "1");
        //链式构建请求
        String result = HttpRequest.get("http://101.36.148.173:17027/api/risk/ledger_info")
                .header("X-HW-ID", "rpa.ioc.301test")//头信息，多个头信息多次调用此方法即可
                .header("X-HW-APPKEY", "V6Ms/P7SvsFN/WdhFYgxrA==")
                .form(paramMap)//表单内容
                .timeout(20000)//超时，毫秒
                .execute().body();
        InfoResultDto infoResultDto = JSONObject.parseObject(result, InfoResultDto.class);

        String total = infoResultDto.getTotal();

        Integer totalNumber = Integer.valueOf(total);
        int totalNum = totalNumber / 100 + 1;
        for (int i = 1; i <= totalNum; i++) {
            paramMap.put("pageSize", "100");
            paramMap.put("pageNum", i);

            //链式构建请求
            result = HttpRequest.get("http://101.36.148.173:17027/api/risk/ledger_info")
                    .header("X-HW-ID", "rpa.ioc.301test")//头信息，多个头信息多次调用此方法即可
                    .header("X-HW-APPKEY", "V6Ms/P7SvsFN/WdhFYgxrA==")
                    .form(paramMap)//表单内容
                    .timeout(20000)//超时，毫秒
                    .execute().body();
            infoResultDto = JSONObject.parseObject(result, InfoResultDto.class);
            List<InfoLedger> infoLedgers = JSONArray.parseArray(infoResultDto.getData(), InfoLedger.class);
            saveOrUpdateBatch(infoLedgers);

            List<LedgerProject> ledgerProjects = ledgerProjectService.selectLedgerProjectList(new LedgerProject());

            infoLedgers.forEach(infoLedger -> {
                Optional<LedgerProject> first = ledgerProjects.stream().filter(ledgerProject -> ledgerProject.getInfoAssetsId()
                        .equals(infoLedger.getId())).findFirst();
                if (first.isPresent()) {
                    //关联id
                    LedgerProject ledgerProject = first.get();
                    ledgerProject.setInfoAssetsId(infoLedger.getId());
                    ledgerProjectService.updateLedgerProject(ledgerProject);
                } else {
                    //新建
                    LedgerProject ledgerProject = new LedgerProject();
                    ledgerProject.setInfoAssetsId(infoLedger.getId());
                    ledgerProject.setName(infoLedger.getName());
                    ledgerProject.setType(infoLedger.getBusiness_type());
                    ledgerProject.setCity(infoLedger.getProvince_name());
                    ledgerProject.setCity(infoLedger.getCity_name());
                    ledgerProject.setCity(infoLedger.getDistrict_name());
                    ledgerProject.setAddress(infoLedger.getName());
                    ledgerProject.setDelFlag("0");
                    ledgerProject.setStatus("0");

                    List<SysDept> sysDepts = sysDeptService.selectDeptList(new SysDept());
                    Optional<SysDept> first1 = sysDepts.stream().filter(sysDept -> sysDept.getDeptName().replace("区域", "")
                            .equals(infoLedger.getCorp_name().replace("公司", ""))).findFirst();
                    if (first1.isPresent()) {
                        ledgerProject.setDeptId(first1.get().getDeptId());
                    }
                    ledgerProjectService.insertLedgerProject(ledgerProject);
                }
            });
        }

        return result;

    }
}
