package com.censoft.censoftrongtong.service.impl;

import java.util.List;

import com.censoft.censoftrongtong.domain.LedgerProject;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.CurrentRiskUserPatrolMapper;
import com.censoft.censoftrongtong.domain.CurrentRiskUserPatrol;
import com.censoft.censoftrongtong.service.ICurrentRiskUserPatrolService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 巡查执行管理Service业务层处理
 * 
 * @author baode
 * @date 2023-12-05
 */
@Service
public class CurrentRiskUserPatrolServiceImpl extends MPJBaseServiceImpl<CurrentRiskUserPatrolMapper, CurrentRiskUserPatrol> implements ICurrentRiskUserPatrolService
{
    @Autowired
    private CurrentRiskUserPatrolMapper currentRiskUserPatrolMapper;

    /**
     * 查询巡查执行管理
     * 
     * @param id 巡查执行管理主键
     * @return 巡查执行管理
     */
    @Override
    public CurrentRiskUserPatrol selectCurrentRiskUserPatrolById(Long id)
    {
        return currentRiskUserPatrolMapper.selectCurrentRiskUserPatrolById(id);
    }

    /**
     * 查询巡查执行管理列表
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 巡查执行管理
     */
    @Override
    public List<CurrentRiskUserPatrol> selectCurrentRiskUserPatrolList(CurrentRiskUserPatrol currentRiskUserPatrol)
    {
        return currentRiskUserPatrolMapper.selectCurrentRiskUserPatrolList(currentRiskUserPatrol);
    }

    /**
     * 根据用户id获取巡检项目
     * @param userId
     * @return
     */
   @Override
    public List<LedgerProject> getPatrolProjectList(Long userId)
    {
        return currentRiskUserPatrolMapper.getPatrolProjectList(userId);
    }


    /**
     * 新增巡查执行管理
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 结果
     */
    @Override
    public int insertCurrentRiskUserPatrol(CurrentRiskUserPatrol currentRiskUserPatrol)
    {
        currentRiskUserPatrol.setCreateTime(DateUtils.getNowDate());
        return currentRiskUserPatrolMapper.insertCurrentRiskUserPatrol(currentRiskUserPatrol);
    }

    /**
     * 修改巡查执行管理
     * 
     * @param currentRiskUserPatrol 巡查执行管理
     * @return 结果
     */
    @Override
    public int updateCurrentRiskUserPatrol(CurrentRiskUserPatrol currentRiskUserPatrol)
    {
        currentRiskUserPatrol.setUpdateTime(DateUtils.getNowDate());
        return currentRiskUserPatrolMapper.updateCurrentRiskUserPatrol(currentRiskUserPatrol);
    }

    /**
     * 批量删除巡查执行管理
     * 
     * @param ids 需要删除的巡查执行管理主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskUserPatrolByIds(Long[] ids)
    {
        return currentRiskUserPatrolMapper.deleteCurrentRiskUserPatrolByIds(ids);
    }

    /**
     * 删除巡查执行管理信息
     * 
     * @param id 巡查执行管理主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskUserPatrolById(Long id)
    {
        return currentRiskUserPatrolMapper.deleteCurrentRiskUserPatrolById(id);
    }
}
