package com.censoft.censoftrongtong.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.censoft.censoftrongtong.mapper.CurrentRiskUserHolidayMapper;
import com.censoft.censoftrongtong.domain.CurrentRiskUserHoliday;
import com.censoft.censoftrongtong.service.ICurrentRiskUserHolidayService;
import com.github.yulichang.base.MPJBaseServiceImpl;
/**
 * 现状风险巡查用户请假Service业务层处理
 * 
 * @author ruoyi
 * @date 2023-12-05
 */
@Service
public class CurrentRiskUserHolidayServiceImpl extends MPJBaseServiceImpl<CurrentRiskUserHolidayMapper, CurrentRiskUserHoliday> implements ICurrentRiskUserHolidayService
{
    @Autowired
    private CurrentRiskUserHolidayMapper currentRiskUserHolidayMapper;

    /**
     * 查询现状风险巡查用户请假
     * 
     * @param id 现状风险巡查用户请假主键
     * @return 现状风险巡查用户请假
     */
    @Override
    public CurrentRiskUserHoliday selectCurrentRiskUserHolidayById(Long id)
    {
        return currentRiskUserHolidayMapper.selectCurrentRiskUserHolidayById(id);
    }

    /**
     * 查询现状风险巡查用户请假列表
     * 
     * @param currentRiskUserHoliday 现状风险巡查用户请假
     * @return 现状风险巡查用户请假
     */
    @Override
    public List<CurrentRiskUserHoliday> selectCurrentRiskUserHolidayList(CurrentRiskUserHoliday currentRiskUserHoliday)
    {
        return currentRiskUserHolidayMapper.selectCurrentRiskUserHolidayList(currentRiskUserHoliday);
    }

    /**
     * 新增现状风险巡查用户请假
     * 
     * @param currentRiskUserHoliday 现状风险巡查用户请假
     * @return 结果
     */
    @Override
    public int insertCurrentRiskUserHoliday(CurrentRiskUserHoliday currentRiskUserHoliday)
    {
        currentRiskUserHoliday.setCreateTime(DateUtils.getNowDate());
        return currentRiskUserHolidayMapper.insertCurrentRiskUserHoliday(currentRiskUserHoliday);
    }

    /**
     * 修改现状风险巡查用户请假
     * 
     * @param currentRiskUserHoliday 现状风险巡查用户请假
     * @return 结果
     */
    @Override
    public int updateCurrentRiskUserHoliday(CurrentRiskUserHoliday currentRiskUserHoliday)
    {
        currentRiskUserHoliday.setUpdateTime(DateUtils.getNowDate());
        return currentRiskUserHolidayMapper.updateCurrentRiskUserHoliday(currentRiskUserHoliday);
    }

    /**
     * 批量删除现状风险巡查用户请假
     * 
     * @param ids 需要删除的现状风险巡查用户请假主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskUserHolidayByIds(Long[] ids)
    {
        return currentRiskUserHolidayMapper.deleteCurrentRiskUserHolidayByIds(ids);
    }

    /**
     * 删除现状风险巡查用户请假信息
     * 
     * @param id 现状风险巡查用户请假主键
     * @return 结果
     */
    @Override
    public int deleteCurrentRiskUserHolidayById(Long id)
    {
        return currentRiskUserHolidayMapper.deleteCurrentRiskUserHolidayById(id);
    }

    @Override
    public List<Long> memberUserIds(Long userId) {
        return currentRiskUserHolidayMapper.memberUserIds(userId);
    }
}
